/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.aggregation.AggregationTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchMergeAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchModule;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchToEstimatePostAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchToEstimateWithBoundsPostAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchToStringPostAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchUnionPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HllSketchAggregatorTest
extends InitializedNullHandlingTest {
    private static final boolean ROUND = true;
    private final AggregationTestHelper helper;
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    public HllSketchAggregatorTest(GroupByQueryConfig config) {
        HllSketchModule.registerSerde();
        this.helper = AggregationTestHelper.createGroupByQueryAggregationTestHelper((List)new HllSketchModule().getJacksonModules(), (GroupByQueryConfig)config, (TemporaryFolder)this.tempFolder);
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<?> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (GroupByQueryConfig config : GroupByQueryRunnerTest.testConfigs()) {
            constructors.add(new Object[]{config});
        }
        return constructors;
    }

    @Test
    public void ingestSketches() throws Exception {
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("hll/hll_sketches.tsv").getFile()), HllSketchAggregatorTest.buildParserJson(Arrays.asList("dim", "multiDim"), Arrays.asList("timestamp", "dim", "multiDim", "sketch")), HllSketchAggregatorTest.buildAggregatorJson("HLLSketchMerge", "sketch", false), 0L, Granularities.NONE, 200, HllSketchAggregatorTest.buildGroupByQueryJson("HLLSketchMerge", "sketch", false));
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Assert.assertEquals((double)200.0, (double)((Double)row.get(0)), (double)0.1);
    }

    @Test
    public void buildSketchesAtIngestionTime() throws Exception {
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("hll/hll_raw.tsv").getFile()), HllSketchAggregatorTest.buildParserJson(Collections.singletonList("dim"), Arrays.asList("timestamp", "dim", "multiDim", "id")), HllSketchAggregatorTest.buildAggregatorJson("HLLSketchBuild", "id", false), 0L, Granularities.NONE, 200, HllSketchAggregatorTest.buildGroupByQueryJson("HLLSketchMerge", "sketch", false));
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Assert.assertEquals((double)200.0, (double)((Double)row.get(0)), (double)0.1);
    }

    @Test
    public void buildSketchesAtQueryTime() throws Exception {
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("hll/hll_raw.tsv").getFile()), HllSketchAggregatorTest.buildParserJson(Arrays.asList("dim", "multiDim", "id"), Arrays.asList("timestamp", "dim", "multiDim", "id")), "[]", 0L, Granularities.NONE, 200, HllSketchAggregatorTest.buildGroupByQueryJson("HLLSketchBuild", "id", false));
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Assert.assertEquals((double)200.0, (double)((Double)row.get(0)), (double)0.1);
    }

    @Test
    public void buildSketchesAtQueryTimeMultiValue() throws Exception {
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("hll/hll_raw.tsv").getFile()), HllSketchAggregatorTest.buildParserJson(Arrays.asList("dim", "multiDim", "id"), Arrays.asList("timestamp", "dim", "multiDim", "id")), "[]", 0L, Granularities.NONE, 200, HllSketchAggregatorTest.buildGroupByQueryJson("HLLSketchBuild", "multiDim", false));
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Assert.assertEquals((double)14.0, (double)((Double)row.get(0)), (double)0.1);
    }

    @Test
    public void roundBuildSketch() throws Exception {
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("hll/hll_raw.tsv").getFile()), HllSketchAggregatorTest.buildParserJson(Arrays.asList("dim", "multiDim", "id"), Arrays.asList("timestamp", "dim", "multiDim", "id")), "[]", 0L, Granularities.NONE, 200, HllSketchAggregatorTest.buildGroupByQueryJson("HLLSketchBuild", "id", true));
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Assert.assertEquals((long)200L, (long)((Long)row.get(0)));
    }

    @Test
    public void roundMergeSketch() throws Exception {
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("hll/hll_sketches.tsv").getFile()), HllSketchAggregatorTest.buildParserJson(Arrays.asList("dim", "multiDim"), Arrays.asList("timestamp", "dim", "multiDim", "sketch")), HllSketchAggregatorTest.buildAggregatorJson("HLLSketchMerge", "sketch", true), 0L, Granularities.NONE, 200, HllSketchAggregatorTest.buildGroupByQueryJson("HLLSketchMerge", "sketch", true));
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Assert.assertEquals((long)200L, (long)((Long)row.get(0)));
    }

    @Test
    public void testPostAggs() throws Exception {
        Sequence seq = this.helper.createIndexAndRunQueryOnSegment(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("hll/hll_sketches.tsv").getFile()), HllSketchAggregatorTest.buildParserJson(Arrays.asList("dim", "multiDim"), Arrays.asList("timestamp", "dim", "multiDim", "sketch")), HllSketchAggregatorTest.buildAggregatorJson("HLLSketchMerge", "sketch", true), 0L, Granularities.NONE, 200, this.helper.getObjectMapper().writeValueAsString((Object)GroupByQuery.builder().setDataSource("test_datasource").setGranularity(Granularities.ALL).setInterval(Intervals.ETERNITY).setAggregatorSpecs(new AggregatorFactory[]{new HllSketchMergeAggregatorFactory("sketch", "sketch", null, null, false)}).setPostAggregatorSpecs((List)ImmutableList.of((Object)new HllSketchToEstimatePostAggregator("estimate", (PostAggregator)new FieldAccessPostAggregator("f1", "sketch"), false), (Object)new HllSketchToEstimateWithBoundsPostAggregator("estimateWithBounds", (PostAggregator)new FieldAccessPostAggregator("f1", "sketch"), Integer.valueOf(2)), (Object)new HllSketchToStringPostAggregator("summary", (PostAggregator)new FieldAccessPostAggregator("f1", "sketch")), (Object)new HllSketchUnionPostAggregator("union", (List)ImmutableList.of((Object)new FieldAccessPostAggregator("f1", "sketch"), (Object)new FieldAccessPostAggregator("f2", "sketch")), null, null))).build()));
        String expectedSummary = "### HLL SKETCH SUMMARY: \n  Log Config K   : 12\n  Hll Target     : HLL_4\n  Current Mode   : SET\n  Memory         : false\n  LB             : 200.0\n  Estimate       : 200.0000988444255\n  UB             : 200.01008469948434\n  OutOfOrder Flag: false\n  Coupon Count   : 200\n";
        List results = seq.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        ResultRow row = (ResultRow)results.get(0);
        Assert.assertEquals((double)200.0, (double)((Double)row.get(0)), (double)0.1);
        Assert.assertEquals((double)200.0, (double)((Double)row.get(1)), (double)0.1);
        Assert.assertArrayEquals((double[])new double[]{200.0, 200.0, 200.0}, (double[])((double[])row.get(2)), (double)0.1);
        Assert.assertEquals((Object)"### HLL SKETCH SUMMARY: \n  Log Config K   : 12\n  Hll Target     : HLL_4\n  Current Mode   : SET\n  Memory         : false\n  LB             : 200.0\n  Estimate       : 200.0000988444255\n  UB             : 200.01008469948434\n  OutOfOrder Flag: false\n  Coupon Count   : 200\n", (Object)row.get(3));
        Assert.assertEquals((Object)"### HLL SKETCH SUMMARY: \n  Log Config K   : 12\n  Hll Target     : HLL_4\n  Current Mode   : SET\n  Memory         : false\n  LB             : 200.0\n  Estimate       : 200.0000988444255\n  UB             : 200.01008469948434\n  OutOfOrder Flag: false\n  Coupon Count   : 200\n", (Object)row.get(4).toString());
    }

    private static String buildParserJson(List<String> dimensions, List<String> columns) {
        ImmutableMap timestampSpec = ImmutableMap.of((Object)"column", (Object)"timestamp", (Object)"format", (Object)"yyyyMMdd");
        ImmutableMap dimensionsSpec = ImmutableMap.of((Object)"dimensions", dimensions, (Object)"dimensionExclusions", Collections.emptyList(), (Object)"spatialDimensions", Collections.emptyList());
        ImmutableMap parseSpec = ImmutableMap.of((Object)"format", (Object)"tsv", (Object)"timestampSpec", (Object)timestampSpec, (Object)"dimensionsSpec", (Object)dimensionsSpec, (Object)"columns", columns, (Object)"listDelimiter", (Object)",");
        ImmutableMap object = ImmutableMap.of((Object)"type", (Object)"string", (Object)"parseSpec", (Object)parseSpec);
        return HllSketchAggregatorTest.toJson(object);
    }

    private static String toJson(Object object) {
        String json;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            json = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return json;
    }

    private static String buildAggregatorJson(String aggregationType, String aggregationFieldName, boolean aggregationRound) {
        Map<String, Object> aggregator = HllSketchAggregatorTest.buildAggregatorObject(aggregationType, aggregationFieldName, aggregationRound);
        return HllSketchAggregatorTest.toJson(Collections.singletonList(aggregator));
    }

    private static Map<String, Object> buildAggregatorObject(String aggregationType, String aggregationFieldName, boolean aggregationRound) {
        return ImmutableMap.of((Object)"type", (Object)aggregationType, (Object)"name", (Object)"sketch", (Object)"fieldName", (Object)aggregationFieldName, (Object)"round", (Object)aggregationRound);
    }

    private static String buildGroupByQueryJson(String aggregationType, String aggregationFieldName, boolean aggregationRound) {
        Map<String, Object> aggregation = HllSketchAggregatorTest.buildAggregatorObject(aggregationType, aggregationFieldName, aggregationRound);
        ImmutableMap object = new ImmutableMap.Builder().put((Object)"queryType", (Object)"groupBy").put((Object)"dataSource", (Object)"test_dataSource").put((Object)"granularity", (Object)"ALL").put((Object)"dimensions", Collections.emptyList()).put((Object)"aggregations", Collections.singletonList(aggregation)).put((Object)"intervals", Collections.singletonList("2017-01-01T00:00:00.000Z/2017-01-31T00:00:00.000Z")).build();
        return HllSketchAggregatorTest.toJson(object);
    }
}

