/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchMergeAggregatorFactory;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.aggregation.post.FinalizingFieldAccessPostAggregator;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HllSketchAggregatorFactoryTest {
    private static final String NAME = "name";
    private static final String FIELD_NAME = "fieldName";
    private static final int LG_K = 12;
    private static final String TGT_HLL_TYPE = TgtHllType.HLL_4.name();
    private static final boolean ROUND = true;
    private static final double ESTIMATE = Math.PI;
    private TestHllSketchAggregatorFactory target;

    @Before
    public void setUp() {
        this.target = new TestHllSketchAggregatorFactory(NAME, FIELD_NAME, 12, TGT_HLL_TYPE, true);
    }

    @Test
    public void testIsRound() {
        Assert.assertEquals((Object)true, (Object)this.target.isRound());
    }

    @Test
    public void testGetRequiredColumns() {
        List aggregatorFactories = this.target.getRequiredColumns();
        Assert.assertEquals((long)1L, (long)aggregatorFactories.size());
        HllSketchAggregatorFactory aggregatorFactory = (HllSketchAggregatorFactory)aggregatorFactories.get(0);
        Assert.assertEquals((Object)FIELD_NAME, (Object)aggregatorFactory.getName());
        Assert.assertEquals((Object)FIELD_NAME, (Object)aggregatorFactory.getFieldName());
        Assert.assertEquals((long)12L, (long)aggregatorFactory.getLgK());
        Assert.assertEquals((Object)TGT_HLL_TYPE, (Object)aggregatorFactory.getTgtHllType());
        Assert.assertEquals((Object)true, (Object)aggregatorFactory.isRound());
    }

    @Test
    public void testFinalizeComputationNull() {
        Assert.assertNull((Object)this.target.finalizeComputation(null));
    }

    @Test
    public void testFinalizeComputationRound() {
        Object actual = this.target.finalizeComputation(HllSketchAggregatorFactoryTest.getMockSketch());
        Assert.assertTrue((boolean)(actual instanceof Long));
        Assert.assertEquals((Object)3L, (Object)actual);
    }

    private static HllSketch getMockSketch() {
        HllSketch sketch = (HllSketch)EasyMock.mock(HllSketch.class);
        EasyMock.expect((Object)sketch.getEstimate()).andReturn((Object)Math.PI);
        EasyMock.replay((Object[])new Object[]{sketch});
        return sketch;
    }

    @Test
    public void testFinalizeComputatioNoRound() {
        TestHllSketchAggregatorFactory t = new TestHllSketchAggregatorFactory(NAME, FIELD_NAME, 12, TGT_HLL_TYPE, false);
        Object actual = t.finalizeComputation(HllSketchAggregatorFactoryTest.getMockSketch());
        Assert.assertTrue((boolean)(actual instanceof Double));
        Assert.assertEquals((Object)Math.PI, (Object)actual);
    }

    @Test
    public void testEqualsSameObject() {
        Assert.assertEquals((Object)((Object)this.target), (Object)((Object)this.target));
    }

    @Test
    public void testEqualsOtherNull() {
        Assert.assertNotEquals((Object)((Object)this.target), null);
    }

    @Test
    public void testEqualsOtherDiffClass() {
        Assert.assertNotEquals((Object)((Object)this.target), (Object)NAME);
    }

    @Test
    public void testEqualsOtherDiffName() {
        TestHllSketchAggregatorFactory other = new TestHllSketchAggregatorFactory("name-diff", FIELD_NAME, 12, TGT_HLL_TYPE, true);
        Assert.assertNotEquals((Object)((Object)this.target), (Object)((Object)other));
    }

    @Test
    public void testEqualsOtherDiffFieldName() {
        TestHllSketchAggregatorFactory other = new TestHllSketchAggregatorFactory(NAME, "fieldName-diff", 12, TGT_HLL_TYPE, true);
        Assert.assertNotEquals((Object)((Object)this.target), (Object)((Object)other));
    }

    @Test
    public void testEqualsOtherDiffLgK() {
        TestHllSketchAggregatorFactory other = new TestHllSketchAggregatorFactory(NAME, FIELD_NAME, 13, TGT_HLL_TYPE, true);
        Assert.assertNotEquals((Object)((Object)this.target), (Object)((Object)other));
    }

    @Test
    public void testEqualsOtherDiffTgtHllType() {
        TestHllSketchAggregatorFactory other = new TestHllSketchAggregatorFactory(NAME, FIELD_NAME, 12, TgtHllType.HLL_8.name(), true);
        Assert.assertNotEquals((Object)((Object)this.target), (Object)((Object)other));
    }

    @Test
    public void testEqualsOtherDiffRound() {
        TestHllSketchAggregatorFactory other = new TestHllSketchAggregatorFactory(NAME, FIELD_NAME, 12, TGT_HLL_TYPE, false);
        Assert.assertNotEquals((Object)((Object)this.target), (Object)((Object)other));
    }

    @Test
    public void testEqualsOtherMatches() {
        TestHllSketchAggregatorFactory other = new TestHllSketchAggregatorFactory(NAME, FIELD_NAME, 12, TGT_HLL_TYPE, true);
        Assert.assertEquals((Object)((Object)this.target), (Object)((Object)other));
    }

    @Test
    public void testToString() {
        String string = this.target.toString();
        List toStringFields = Arrays.stream(HllSketchAggregatorFactory.class.getDeclaredFields()).filter(HllSketchAggregatorFactoryTest::isToStringField).collect(Collectors.toList());
        for (Field field : toStringFields) {
            String expectedToken = HllSketchAggregatorFactoryTest.formatFieldForToString(field);
            Assert.assertTrue((String)("Missing \"" + expectedToken + "\""), (boolean)string.contains(expectedToken));
        }
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count"), new HllSketchBuildAggregatorFactory("hllBuild", "col", null, null, false), new HllSketchBuildAggregatorFactory("hllBuildRound", "col", null, null, true), new HllSketchMergeAggregatorFactory("hllMerge", "col", null, null, false), new HllSketchMergeAggregatorFactory("hllMergeRound", "col", null, null, true)}).postAggregators(new PostAggregator[]{new FieldAccessPostAggregator("hllBuild-access", "hllBuild"), new FinalizingFieldAccessPostAggregator("hllBuild-finalize", "hllBuild"), new FieldAccessPostAggregator("hllBuildRound-access", "hllBuildRound"), new FinalizingFieldAccessPostAggregator("hllBuildRound-finalize", "hllBuildRound"), new FieldAccessPostAggregator("hllMerge-access", "hllMerge"), new FinalizingFieldAccessPostAggregator("hllMerge-finalize", "hllMerge"), new FieldAccessPostAggregator("hllMergeRound-access", "hllMergeRound"), new FinalizingFieldAccessPostAggregator("hllMergeRound-finalize", "hllMergeRound")}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("count", ValueType.LONG).add("hllBuild", null).add("hllBuildRound", null).add("hllMerge", null).add("hllMergeRound", null).add("hllBuild-access", ValueType.COMPLEX).add("hllBuild-finalize", ValueType.DOUBLE).add("hllBuildRound-access", ValueType.COMPLEX).add("hllBuildRound-finalize", ValueType.LONG).add("hllMerge-access", ValueType.COMPLEX).add("hllMerge-finalize", ValueType.DOUBLE).add("hllMergeRound-access", ValueType.COMPLEX).add("hllMergeRound-finalize", ValueType.LONG).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }

    private static boolean isToStringField(Field field) {
        int modfiers = field.getModifiers();
        return Modifier.isPrivate(modfiers) && !Modifier.isStatic(modfiers) && Modifier.isFinal(modfiers);
    }

    private static String formatFieldForToString(Field field) {
        return " " + field.getName() + "=";
    }

    private static class TestHllSketchAggregatorFactory
    extends HllSketchAggregatorFactory {
        private static final byte DUMMY_CACHE_TYPE_ID = 0;
        private static final Aggregator DUMMY_AGGREGATOR = null;
        private static final BufferAggregator DUMMY_BUFFER_AGGREGATOR = null;
        private static final String DUMMY_TYPE_NAME = null;
        private static final int DUMMY_SIZE = 0;

        TestHllSketchAggregatorFactory(String name, String fieldName, @Nullable Integer lgK, @Nullable String tgtHllType, boolean round) {
            super(name, fieldName, lgK, tgtHllType, round);
        }

        protected byte getCacheTypeId() {
            return 0;
        }

        public Aggregator factorize(ColumnSelectorFactory metricFactory) {
            return DUMMY_AGGREGATOR;
        }

        public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
            return DUMMY_BUFFER_AGGREGATOR;
        }

        public String getComplexTypeName() {
            return DUMMY_TYPE_NAME;
        }

        public int getMaxIntermediateSize() {
            return 0;
        }
    }
}

