/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import java.io.BufferedWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.datasketches.hll.HllSketch;
import org.apache.druid.java.util.common.StringUtils;

class GenerateTestData {
    GenerateTestData() {
    }

    public static void main(String[] args) throws Exception {
        GenerateTestData.generateSketches();
    }

    private static void generateSketches() throws Exception {
        int lgK = 12;
        String date = "20170101";
        Path rawPath = FileSystems.getDefault().getPath("hll_raw.tsv", new String[0]);
        Path sketchPath = FileSystems.getDefault().getPath("hll_sketches.tsv", new String[0]);
        try (BufferedWriter out1 = Files.newBufferedWriter(rawPath, StandardCharsets.UTF_8, new OpenOption[0]);
             BufferedWriter out2 = Files.newBufferedWriter(sketchPath, StandardCharsets.UTF_8, new OpenOption[0]);){
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            int key = 0;
            for (int i = 0; i < 100; ++i) {
                HllSketch sketch = new HllSketch(lgK);
                String dimension = Integer.toString(((Random)rand).nextInt(10) + 1);
                GenerateTestData.writeRawRecord(out1, date, dimension, key);
                sketch.update((long)key++);
                GenerateTestData.writeRawRecord(out1, date, dimension, key);
                sketch.update((long)key++);
                GenerateTestData.writeSketchRecord(out2, date, dimension, sketch);
            }
        }
    }

    private static void writeRawRecord(BufferedWriter out, String date, String dimension, int id) throws Exception {
        int parsed;
        out.write(date);
        out.write("\t");
        out.write(dimension);
        out.write("\t");
        for (int i = parsed = Integer.parseInt(dimension); i < parsed + 5; ++i) {
            out.write(Integer.toString(i));
            if (i + 1 >= parsed + 5) continue;
            out.write(",");
        }
        out.write("\t");
        out.write(Integer.toString(id));
        out.newLine();
    }

    private static void writeSketchRecord(BufferedWriter out, String date, String dimension, HllSketch sketch) throws Exception {
        int parsed;
        out.write(date);
        out.write("\t");
        out.write(dimension);
        out.write("\t");
        for (int i = parsed = Integer.parseInt(dimension); i < parsed + 5; ++i) {
            out.write(Integer.toString(i));
            if (i + 1 >= parsed + 5) continue;
            out.write(",");
        }
        out.write("\t");
        out.write(StringUtils.encodeBase64String((byte[])sketch.toCompactByteArray()));
        out.newLine();
    }
}

