/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.stat.inference.TTest;
import org.apache.datasketches.tuple.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesSketchIterator;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchMultiPostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.column.ValueType;

public class ArrayOfDoublesSketchTTestPostAggregator
extends ArrayOfDoublesSketchMultiPostAggregator {
    @JsonCreator
    public ArrayOfDoublesSketchTTestPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fields") List<PostAggregator> fields) {
        super(name, fields);
        if (fields.size() != 2) {
            throw new IAE("Illegal number of fields[%d], must be 2", new Object[]{fields.size()});
        }
    }

    public Comparator<double[]> getComparator() {
        throw new IAE("Comparing arrays of p values is not supported", new Object[0]);
    }

    public double[] compute(Map<String, Object> combinedAggregators) {
        ArrayOfDoublesSketch sketch1 = (ArrayOfDoublesSketch)this.getFields().get(0).compute(combinedAggregators);
        ArrayOfDoublesSketch sketch2 = (ArrayOfDoublesSketch)this.getFields().get(1).compute(combinedAggregators);
        if (sketch1.getNumValues() != sketch2.getNumValues()) {
            throw new IAE("Sketches have different number of values: %d and %d", new Object[]{sketch1.getNumValues(), sketch2.getNumValues()});
        }
        SummaryStatistics[] stats1 = ArrayOfDoublesSketchTTestPostAggregator.getStats(sketch1);
        SummaryStatistics[] stats2 = ArrayOfDoublesSketchTTestPostAggregator.getStats(sketch2);
        int numberOfValues = sketch1.getNumValues();
        double[] pValues = new double[numberOfValues];
        TTest test = new TTest();
        for (int i = 0; i < pValues.length; ++i) {
            pValues[i] = test.tTest((StatisticalSummary)stats1[i], (StatisticalSummary)stats2[i]);
        }
        return pValues;
    }

    public ValueType getType() {
        return ValueType.DOUBLE_ARRAY;
    }

    private static SummaryStatistics[] getStats(ArrayOfDoublesSketch sketch) {
        SummaryStatistics[] stats = new SummaryStatistics[sketch.getNumValues()];
        Arrays.setAll(stats, i -> new SummaryStatistics());
        ArrayOfDoublesSketchIterator it = sketch.iterator();
        while (it.next()) {
            double[] values = it.getValues();
            for (int i2 = 0; i2 < values.length; ++i2) {
                stats[i2].addValue(values[i2]);
            }
        }
        return stats;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(41).appendCacheables(this.getFields()).build();
    }
}

