/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.datasketches.Util;
import org.apache.datasketches.tuple.ArrayOfDoublesSketch;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchMultiPostAggregator;
import org.apache.druid.query.aggregation.datasketches.tuple.ArrayOfDoublesSketchOperations;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.column.ValueType;

public class ArrayOfDoublesSketchSetOpPostAggregator
extends ArrayOfDoublesSketchMultiPostAggregator {
    private final ArrayOfDoublesSketchOperations.Operation operation;
    private final int nominalEntries;
    private final int numberOfValues;

    @JsonCreator
    public ArrayOfDoublesSketchSetOpPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="operation") String operation, @JsonProperty(value="nominalEntries") @Nullable Integer nominalEntries, @JsonProperty(value="numberOfValues") @Nullable Integer numberOfValues, @JsonProperty(value="fields") List<PostAggregator> fields) {
        super(name, fields);
        this.operation = ArrayOfDoublesSketchOperations.Operation.valueOf(operation);
        this.nominalEntries = nominalEntries == null ? 4096 : nominalEntries;
        this.numberOfValues = numberOfValues == null ? 1 : numberOfValues;
        Util.checkIfPowerOf2((int)this.nominalEntries, (String)"size");
        if (fields.size() <= 1) {
            throw new IAE("Illegal number of fields[%d], must be > 1", new Object[]{fields.size()});
        }
    }

    public Comparator<ArrayOfDoublesSketch> getComparator() {
        return ArrayOfDoublesSketchAggregatorFactory.COMPARATOR;
    }

    public ArrayOfDoublesSketch compute(Map<String, Object> combinedAggregators) {
        ArrayOfDoublesSketch[] sketches = new ArrayOfDoublesSketch[this.getFields().size()];
        for (int i = 0; i < sketches.length; ++i) {
            sketches[i] = (ArrayOfDoublesSketch)this.getFields().get(i).compute(combinedAggregators);
        }
        return this.operation.apply(this.nominalEntries, this.numberOfValues, sketches);
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(34).appendCacheables(this.getFields()).appendInt(this.nominalEntries).appendInt(this.numberOfValues).appendString(this.operation.toString()).build();
    }

    public ValueType getType() {
        return ValueType.COMPLEX;
    }

    @JsonProperty
    public String getOperation() {
        return this.operation.toString();
    }

    @JsonProperty
    public int getNominalEntries() {
        return this.nominalEntries;
    }

    @JsonProperty
    public int getNumberOfValues() {
        return this.numberOfValues;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.getName() + '\'' + ", fields=" + this.getFields() + ", operation=" + (Object)((Object)this.operation) + ", nominalEntries=" + this.nominalEntries + ", numberOfValues=" + this.numberOfValues + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayOfDoublesSketchSetOpPostAggregator that = (ArrayOfDoublesSketchSetOpPostAggregator)o;
        return this.nominalEntries == that.nominalEntries && this.numberOfValues == that.numberOfValues && this.operation == that.operation;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.operation, this.nominalEntries, this.numberOfValues});
    }
}

