/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import com.google.common.util.concurrent.Striped;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.tuple.ArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesSketches;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.monomorphicprocessing.HotLoopCallee;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.IndexedInts;

public class ArrayOfDoublesSketchBuildBufferAggregator
implements BufferAggregator {
    private static final int NUM_STRIPES = 64;
    private final DimensionSelector keySelector;
    private final BaseDoubleColumnValueSelector[] valueSelectors;
    private final int nominalEntries;
    private final int maxIntermediateSize;
    @Nullable
    private double[] values;
    private final Striped<ReadWriteLock> stripedLock = Striped.readWriteLock((int)64);

    public ArrayOfDoublesSketchBuildBufferAggregator(DimensionSelector keySelector, List<BaseDoubleColumnValueSelector> valueSelectors, int nominalEntries, int maxIntermediateSize) {
        this.keySelector = keySelector;
        this.valueSelectors = valueSelectors.toArray(new BaseDoubleColumnValueSelector[0]);
        this.nominalEntries = nominalEntries;
        this.maxIntermediateSize = maxIntermediateSize;
        this.values = new double[valueSelectors.size()];
    }

    public void init(ByteBuffer buf, int position) {
        WritableMemory mem = WritableMemory.wrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        WritableMemory region = mem.writableRegion((long)position, (long)this.maxIntermediateSize);
        new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(this.nominalEntries).setNumberOfValues(this.valueSelectors.length).setNumberOfValues(this.valueSelectors.length).build(region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregate(ByteBuffer buf, int position) {
        for (int i = 0; i < this.valueSelectors.length; ++i) {
            if (this.valueSelectors[i].isNull()) {
                return;
            }
            this.values[i] = this.valueSelectors[i].getDouble();
        }
        IndexedInts keys = this.keySelector.getRow();
        WritableMemory mem = WritableMemory.wrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        WritableMemory region = mem.writableRegion((long)position, (long)this.maxIntermediateSize);
        Lock lock = ((ReadWriteLock)this.stripedLock.getAt(ArrayOfDoublesSketchBuildBufferAggregator.lockIndex(position))).writeLock();
        lock.lock();
        try {
            ArrayOfDoublesUpdatableSketch sketch = ArrayOfDoublesSketches.wrapUpdatableSketch((WritableMemory)region);
            int keysSize = keys.size();
            for (int i = 0; i < keysSize; ++i) {
                String key = this.keySelector.lookupName(keys.get(i));
                sketch.update(key, this.values);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(ByteBuffer buf, int position) {
        WritableMemory mem = WritableMemory.wrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        WritableMemory region = mem.writableRegion((long)position, (long)this.maxIntermediateSize);
        Lock lock = ((ReadWriteLock)this.stripedLock.getAt(ArrayOfDoublesSketchBuildBufferAggregator.lockIndex(position))).readLock();
        lock.lock();
        try {
            ArrayOfDoublesUpdatableSketch sketch = (ArrayOfDoublesUpdatableSketch)ArrayOfDoublesSketches.wrapSketch((Memory)region);
            ArrayOfDoublesCompactSketch arrayOfDoublesCompactSketch = sketch.compact();
            return arrayOfDoublesCompactSketch;
        }
        finally {
            lock.unlock();
        }
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void close() {
        this.values = null;
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("keySelector", (HotLoopCallee)this.keySelector);
        inspector.visit("valueSelectors", (Object[])this.valueSelectors);
    }

    static int lockIndex(int position) {
        return ArrayOfDoublesSketchBuildBufferAggregator.smear(position) % 64;
    }

    private static int smear(int hashCode) {
        hashCode ^= hashCode >>> 20 ^ hashCode >>> 12;
        return hashCode ^ hashCode >>> 7 ^ hashCode >>> 4;
    }
}

