/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta;

import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.query.aggregation.datasketches.theta.SketchHolder;
import org.apache.druid.query.aggregation.datasketches.theta.SketchHolderObjectStrategy;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.ComplexColumnPartSupplier;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.LargeColumnSupportedComplexColumnSerializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class SketchMergeComplexMetricSerde
extends ComplexMetricSerde {
    private SketchHolderObjectStrategy strategy = new SketchHolderObjectStrategy();

    public String getTypeName() {
        return "thetaSketch";
    }

    public ComplexMetricExtractor<?> getExtractor() {
        return new ComplexMetricExtractor<SketchHolder>(){

            public Class<SketchHolder> extractedClass() {
                return SketchHolder.class;
            }

            @Nullable
            public SketchHolder extractValue(InputRow inputRow, String metricName) {
                Object object = inputRow.getRaw(metricName);
                return object == null ? null : SketchHolder.deserialize(object);
            }
        };
    }

    public void deserializeColumn(ByteBuffer buffer, ColumnBuilder builder) {
        GenericIndexed ge = GenericIndexed.read((ByteBuffer)buffer, (ObjectStrategy)this.strategy, (SmooshedFileMapper)builder.getFileMapper());
        builder.setComplexColumnSupplier((Supplier)new ComplexColumnPartSupplier(this.getTypeName(), ge));
    }

    public ObjectStrategy<SketchHolder> getObjectStrategy() {
        return this.strategy;
    }

    public GenericColumnSerializer getSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String column) {
        return LargeColumnSupportedComplexColumnSerializer.create((SegmentWriteOutMedium)segmentWriteOutMedium, (String)column, this.getObjectStrategy());
    }
}

