/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.druid.query.aggregation.datasketches.theta.SketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.theta.SketchHolder;
import org.apache.druid.segment.column.ValueType;

public class SketchMergeAggregatorFactory
extends SketchAggregatorFactory {
    private final boolean shouldFinalize;
    private final boolean isInputThetaSketch;
    @Nullable
    private final Integer errorBoundsStdDev;

    @JsonCreator
    public SketchMergeAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="size") @Nullable Integer size, @JsonProperty(value="shouldFinalize") @Nullable Boolean shouldFinalize, @JsonProperty(value="isInputThetaSketch") @Nullable Boolean isInputThetaSketch, @JsonProperty(value="errorBoundsStdDev") @Nullable Integer errorBoundsStdDev) {
        super(name, fieldName, size, (byte)15);
        this.shouldFinalize = shouldFinalize == null ? true : shouldFinalize;
        this.isInputThetaSketch = isInputThetaSketch == null ? false : isInputThetaSketch;
        this.errorBoundsStdDev = errorBoundsStdDev;
    }

    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new SketchMergeAggregatorFactory(this.fieldName, this.fieldName, this.size, this.shouldFinalize, this.isInputThetaSketch, this.errorBoundsStdDev));
    }

    public AggregatorFactory getCombiningFactory() {
        return new SketchMergeAggregatorFactory(this.name, this.name, this.size, this.shouldFinalize, false, this.errorBoundsStdDev);
    }

    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && other instanceof SketchMergeAggregatorFactory) {
            SketchMergeAggregatorFactory castedOther = (SketchMergeAggregatorFactory)other;
            return new SketchMergeAggregatorFactory(this.name, this.name, Math.max(this.size, castedOther.size), this.shouldFinalize, false, this.errorBoundsStdDev);
        }
        throw new AggregatorFactoryNotMergeableException((AggregatorFactory)this, other);
    }

    @JsonProperty
    public boolean getShouldFinalize() {
        return this.shouldFinalize;
    }

    @JsonProperty
    public boolean getIsInputThetaSketch() {
        return this.isInputThetaSketch;
    }

    @Nullable
    @JsonProperty
    public Integer getErrorBoundsStdDev() {
        return this.errorBoundsStdDev;
    }

    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        if (this.shouldFinalize) {
            SketchHolder holder = (SketchHolder)object;
            if (this.errorBoundsStdDev != null) {
                return holder.getEstimateWithErrorBounds(this.errorBoundsStdDev);
            }
            return holder.getEstimate();
        }
        return object;
    }

    public String getComplexTypeName() {
        if (this.isInputThetaSketch) {
            return "thetaSketchMerge";
        }
        return "thetaSketchBuild";
    }

    public ValueType getType() {
        return ValueType.COMPLEX;
    }

    public ValueType getFinalizedType() {
        if (this.shouldFinalize && this.errorBoundsStdDev == null) {
            return ValueType.DOUBLE;
        }
        return ValueType.COMPLEX;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SketchMergeAggregatorFactory that = (SketchMergeAggregatorFactory)((Object)o);
        if (this.shouldFinalize != that.shouldFinalize) {
            return false;
        }
        if (this.errorBoundsStdDev == null ^ that.errorBoundsStdDev == null) {
            return false;
        }
        if (this.errorBoundsStdDev != null && that.errorBoundsStdDev != null && this.errorBoundsStdDev.intValue() != that.errorBoundsStdDev.intValue()) {
            return false;
        }
        return this.isInputThetaSketch == that.isInputThetaSketch;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.shouldFinalize ? 1 : 0);
        result = 31 * result + (this.isInputThetaSketch ? 1 : 0);
        result = 31 * result + (this.errorBoundsStdDev != null ? this.errorBoundsStdDev.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "SketchMergeAggregatorFactory{fieldName=" + this.fieldName + ", name=" + this.name + ", size=" + this.size + ", shouldFinalize=" + this.shouldFinalize + ", isInputThetaSketch=" + this.isInputThetaSketch + ", errorBoundsStdDev=" + this.errorBoundsStdDev + "}";
    }
}

