/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.IdentityHashMap;
import org.apache.datasketches.Family;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Union;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchHolder;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;

public class SketchBufferAggregator
implements BufferAggregator {
    private final BaseObjectColumnValueSelector selector;
    private final int size;
    private final int maxIntermediateSize;
    private final IdentityHashMap<ByteBuffer, Int2ObjectMap<Union>> unions = new IdentityHashMap();
    private final IdentityHashMap<ByteBuffer, WritableMemory> memCache = new IdentityHashMap();

    public SketchBufferAggregator(BaseObjectColumnValueSelector selector, int size, int maxIntermediateSize) {
        this.selector = selector;
        this.size = size;
        this.maxIntermediateSize = maxIntermediateSize;
    }

    public void init(ByteBuffer buf, int position) {
        this.createNewUnion(buf, position, false);
    }

    public void aggregate(ByteBuffer buf, int position) {
        Object update = this.selector.getObject();
        if (update == null) {
            return;
        }
        Union union = this.getOrCreateUnion(buf, position);
        SketchAggregator.updateUnion(union, update);
    }

    public Object get(ByteBuffer buf, int position) {
        Union union;
        Int2ObjectMap<Union> unionMap = this.unions.get(buf);
        Union union2 = union = unionMap != null ? (Union)unionMap.get(position) : null;
        if (union == null) {
            return SketchHolder.EMPTY;
        }
        return SketchHolder.of(union.getResult(true, null));
    }

    private Union getOrCreateUnion(ByteBuffer buf, int position) {
        Union union;
        Int2ObjectMap<Union> unionMap = this.unions.get(buf);
        Union union2 = union = unionMap != null ? (Union)unionMap.get(position) : null;
        if (union != null) {
            return union;
        }
        return this.createNewUnion(buf, position, true);
    }

    private Union createNewUnion(ByteBuffer buf, int position, boolean isWrapped) {
        WritableMemory mem = this.getMemory(buf).writableRegion((long)position, (long)this.maxIntermediateSize);
        Union union = isWrapped ? (Union)SetOperation.wrap((WritableMemory)mem) : (Union)SetOperation.builder().setNominalEntries(this.size).build(Family.UNION, mem);
        Int2ObjectOpenHashMap unionMap = this.unions.get(buf);
        if (unionMap == null) {
            unionMap = new Int2ObjectOpenHashMap();
            this.unions.put(buf, (Int2ObjectMap<Union>)unionMap);
        }
        unionMap.put(position, (Object)union);
        return union;
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public double getDouble(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void close() {
        this.unions.clear();
        this.memCache.clear();
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", (Object)this.selector);
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        this.createNewUnion(newBuffer, newPosition, true);
        Int2ObjectMap<Union> unionMap = this.unions.get(oldBuffer);
        if (unionMap != null) {
            unionMap.remove(oldPosition);
            if (unionMap.isEmpty()) {
                this.unions.remove(oldBuffer);
                this.memCache.remove(oldBuffer);
            }
        }
    }

    private WritableMemory getMemory(ByteBuffer buffer) {
        WritableMemory mem = this.memCache.get(buffer);
        if (mem == null) {
            mem = WritableMemory.wrap((ByteBuffer)buffer, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            this.memCache.put(buffer, mem);
        }
        return mem;
    }
}

