/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.datasketches.Util;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesUnion;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.ObjectAggregateCombiner;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchBuildAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchBuildBufferAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchMergeAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchMergeAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchMergeBufferAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchOperations;
import org.apache.druid.query.aggregation.datasketches.quantiles.NoopDoublesSketchAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.NoopDoublesSketchBufferAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ValueType;

public class DoublesSketchAggregatorFactory
extends AggregatorFactory {
    public static final Comparator<DoublesSketch> COMPARATOR = Comparator.nullsFirst(Comparator.comparingLong(DoublesSketch::getN));
    public static final int DEFAULT_K = 128;
    private static final long MAX_STREAM_LENGTH = 1000000000L;
    private final String name;
    private final String fieldName;
    private final int k;
    private final byte cacheTypeId;

    @JsonCreator
    public DoublesSketchAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="k") Integer k) {
        this(name, fieldName, k, 27);
    }

    DoublesSketchAggregatorFactory(String name, String fieldName, Integer k, byte cacheTypeId) {
        if (name == null) {
            throw new IAE("Must have a valid, non-null aggregator name", new Object[0]);
        }
        this.name = name;
        if (fieldName == null) {
            throw new IAE("Parameter fieldName must be specified", new Object[0]);
        }
        this.fieldName = fieldName;
        this.k = k == null ? 128 : k;
        Util.checkIfPowerOf2((int)this.k, (String)"k");
        this.cacheTypeId = cacheTypeId;
    }

    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        if (metricFactory.getColumnCapabilities(this.fieldName) != null && ValueType.isNumeric((ValueType)metricFactory.getColumnCapabilities(this.fieldName).getType())) {
            ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
            if (selector instanceof NilColumnValueSelector) {
                return new NoopDoublesSketchAggregator();
            }
            return new DoublesSketchBuildAggregator((ColumnValueSelector<Double>)selector, this.k);
        }
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (selector instanceof NilColumnValueSelector) {
            return new NoopDoublesSketchAggregator();
        }
        return new DoublesSketchMergeAggregator(selector, this.k);
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        if (metricFactory.getColumnCapabilities(this.fieldName) != null && ValueType.isNumeric((ValueType)metricFactory.getColumnCapabilities(this.fieldName).getType())) {
            ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
            if (selector instanceof NilColumnValueSelector) {
                return new NoopDoublesSketchBufferAggregator();
            }
            return new DoublesSketchBuildBufferAggregator((ColumnValueSelector<Double>)selector, this.k, this.getMaxIntermediateSizeWithNulls());
        }
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (selector instanceof NilColumnValueSelector) {
            return new NoopDoublesSketchBufferAggregator();
        }
        return new DoublesSketchMergeBufferAggregator(selector, this.k, this.getMaxIntermediateSizeWithNulls());
    }

    public Object deserialize(Object object) {
        return DoublesSketchOperations.deserialize(object);
    }

    public Comparator<DoublesSketch> getComparator() {
        return COMPARATOR;
    }

    public Object combine(Object lhs, Object rhs) {
        DoublesUnion union = DoublesUnion.builder().setMaxK(this.k).build();
        union.update((DoublesSketch)lhs);
        union.update((DoublesSketch)rhs);
        return union.getResultAndReset();
    }

    public AggregateCombiner makeAggregateCombiner() {
        return new ObjectAggregateCombiner<DoublesSketch>(){
            private final DoublesUnion union;
            {
                this.union = DoublesUnion.builder().setMaxK(DoublesSketchAggregatorFactory.this.k).build();
            }

            public void reset(ColumnValueSelector selector) {
                this.union.reset();
                this.fold(selector);
            }

            public void fold(ColumnValueSelector selector) {
                DoublesSketch sketch = (DoublesSketch)selector.getObject();
                this.union.update(sketch);
            }

            @Nullable
            public DoublesSketch getObject() {
                return this.union.getResult();
            }

            public Class<DoublesSketch> classOfObject() {
                return DoublesSketch.class;
            }
        };
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public int getK() {
        return this.k;
    }

    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    public int getMaxIntermediateSize() {
        return DoublesSketch.getUpdatableStorageBytes((int)this.k, (long)1000000000L);
    }

    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new DoublesSketchAggregatorFactory(this.fieldName, this.fieldName, this.k));
    }

    public AggregatorFactory getCombiningFactory() {
        return new DoublesSketchMergeAggregatorFactory(this.name, this.k);
    }

    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && other instanceof DoublesSketchAggregatorFactory) {
            return new DoublesSketchMergeAggregatorFactory(this.name, Math.max(this.k, ((DoublesSketchAggregatorFactory)other).k));
        }
        throw new AggregatorFactoryNotMergeableException((AggregatorFactory)this, other);
    }

    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object == null ? null : Long.valueOf(((DoublesSketch)object).getN());
    }

    public String getComplexTypeName() {
        return "quantilesDoublesSketch";
    }

    public ValueType getType() {
        return ValueType.COMPLEX;
    }

    public ValueType getFinalizedType() {
        return ValueType.LONG;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(this.cacheTypeId).appendString(this.name).appendString(this.fieldName).appendInt(this.k).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !((Object)((Object)this)).getClass().equals(o.getClass())) {
            return false;
        }
        DoublesSketchAggregatorFactory that = (DoublesSketchAggregatorFactory)((Object)o);
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.fieldName.equals(that.fieldName)) {
            return false;
        }
        return this.k == that.k;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName, this.k);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{name=" + this.name + ", fieldName=" + this.fieldName + ", k=" + this.k + "}";
    }
}

