/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll.sql;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchMergeAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public abstract class HllSketchBaseSqlAggregator
implements SqlAggregator {
    private static final boolean ROUND = true;

    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        HllSketchAggregatorFactory aggregatorFactory;
        String aggregatorName;
        String tgtHllType;
        int logK;
        RexNode columnRexNode = Expressions.fromFieldAccess((RowSignature)rowSignature, (Project)project, (int)((Integer)aggregateCall.getArgList().get(0)));
        DruidExpression columnArg = Expressions.toDruidExpression((PlannerContext)plannerContext, (RowSignature)rowSignature, (RexNode)columnRexNode);
        if (columnArg == null) {
            return null;
        }
        if (aggregateCall.getArgList().size() >= 2) {
            RexNode logKarg = Expressions.fromFieldAccess((RowSignature)rowSignature, (Project)project, (int)((Integer)aggregateCall.getArgList().get(1)));
            if (!logKarg.isA(SqlKind.LITERAL)) {
                return null;
            }
            logK = ((Number)((Object)RexLiteral.value((RexNode)logKarg))).intValue();
        } else {
            logK = 12;
        }
        if (aggregateCall.getArgList().size() >= 3) {
            RexNode tgtHllTypeArg = Expressions.fromFieldAccess((RowSignature)rowSignature, (Project)project, (int)((Integer)aggregateCall.getArgList().get(2)));
            if (!tgtHllTypeArg.isA(SqlKind.LITERAL)) {
                return null;
            }
            tgtHllType = RexLiteral.stringValue((RexNode)tgtHllTypeArg);
        } else {
            tgtHllType = HllSketchAggregatorFactory.DEFAULT_TGT_HLL_TYPE.name();
        }
        ArrayList<VirtualColumn> virtualColumns = new ArrayList<VirtualColumn>();
        String string = aggregatorName = finalizeAggregations ? Calcites.makePrefixedName((String)name, (String)"a") : name;
        if (columnArg.isDirectColumnAccess() && rowSignature.getColumnType(columnArg.getDirectColumn()).orElse(null) == ValueType.COMPLEX) {
            aggregatorFactory = new HllSketchMergeAggregatorFactory(aggregatorName, columnArg.getDirectColumn(), logK, tgtHllType, true);
        } else {
            DimensionSpec dimensionSpec;
            RelDataType dataType = columnRexNode.getType();
            ValueType inputType = Calcites.getValueTypeForRelDataType((RelDataType)dataType);
            if (inputType == null) {
                throw new ISE("Cannot translate sqlTypeName[%s] to Druid type for field[%s]", new Object[]{dataType.getSqlTypeName(), aggregatorName});
            }
            if (columnArg.isDirectColumnAccess()) {
                dimensionSpec = columnArg.getSimpleExtraction().toDimensionSpec(null, inputType);
            } else {
                VirtualColumn virtualColumn = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(plannerContext, columnArg, dataType);
                dimensionSpec = new DefaultDimensionSpec(virtualColumn.getOutputName(), null, inputType);
                virtualColumns.add(virtualColumn);
            }
            aggregatorFactory = new HllSketchBuildAggregatorFactory(aggregatorName, dimensionSpec.getDimension(), logK, tgtHllType, true);
        }
        return this.toAggregation(name, finalizeAggregations, virtualColumns, aggregatorFactory);
    }

    protected abstract Aggregation toAggregation(String var1, boolean var2, List<VirtualColumn> var3, AggregatorFactory var4);
}

