/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchObjectStrategy;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.ComplexColumnPartSupplier;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.LargeColumnSupportedComplexColumnSerializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class HllSketchMergeComplexMetricSerde
extends ComplexMetricSerde {
    public String getTypeName() {
        return "HLLSketch";
    }

    public ObjectStrategy getObjectStrategy() {
        return HllSketchObjectStrategy.STRATEGY;
    }

    public ComplexMetricExtractor getExtractor() {
        return new ComplexMetricExtractor(){

            public Class<?> extractedClass() {
                return HllSketch.class;
            }

            public HllSketch extractValue(InputRow inputRow, String metricName) {
                Object object = inputRow.getRaw(metricName);
                if (object == null) {
                    return null;
                }
                return HllSketchMergeComplexMetricSerde.deserializeSketch(object);
            }
        };
    }

    public void deserializeColumn(ByteBuffer buf, ColumnBuilder columnBuilder) {
        columnBuilder.setComplexColumnSupplier((Supplier)new ComplexColumnPartSupplier(this.getTypeName(), GenericIndexed.read((ByteBuffer)buf, (ObjectStrategy)HllSketchObjectStrategy.STRATEGY, (SmooshedFileMapper)columnBuilder.getFileMapper())));
    }

    static HllSketch deserializeSketch(Object object) {
        if (object instanceof String) {
            return HllSketch.wrap((Memory)Memory.wrap((byte[])StringUtils.decodeBase64((byte[])((String)object).getBytes(StandardCharsets.UTF_8))));
        }
        if (object instanceof byte[]) {
            return HllSketch.wrap((Memory)Memory.wrap((byte[])((byte[])object)));
        }
        if (object instanceof HllSketch) {
            return (HllSketch)object;
        }
        throw new IAE("Object is not of a type that can be deserialized to an HllSketch:" + object.getClass().getName(), new Object[0]);
    }

    public GenericColumnSerializer getSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String column) {
        return LargeColumnSupportedComplexColumnSerializer.create((SegmentWriteOutMedium)segmentWriteOutMedium, (String)column, (ObjectStrategy)this.getObjectStrategy());
    }
}

