/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildBufferAggregator;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;

public class HllSketchBuildAggregatorFactory
extends HllSketchAggregatorFactory {
    @JsonCreator
    public HllSketchBuildAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="lgK") @Nullable Integer lgK, @JsonProperty(value="tgtHllType") @Nullable String tgtHllType, @JsonProperty(value="round") boolean round) {
        super(name, fieldName, lgK, tgtHllType, round);
    }

    public String getComplexTypeName() {
        return "HLLSketchBuild";
    }

    @Override
    protected byte getCacheTypeId() {
        return 46;
    }

    public Aggregator factorize(ColumnSelectorFactory columnSelectorFactory) {
        ColumnValueSelector selector = columnSelectorFactory.makeColumnValueSelector(this.getFieldName());
        return new HllSketchBuildAggregator((ColumnValueSelector<Object>)selector, this.getLgK(), TgtHllType.valueOf((String)this.getTgtHllType()));
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory columnSelectorFactory) {
        ColumnValueSelector selector = columnSelectorFactory.makeColumnValueSelector(this.getFieldName());
        return new HllSketchBuildBufferAggregator((ColumnValueSelector<Object>)selector, this.getLgK(), TgtHllType.valueOf((String)this.getTgtHllType()), this.getMaxIntermediateSize());
    }

    public int getMaxIntermediateSize() {
        return HllSketch.getMaxUpdatableSerializationBytes((int)this.getLgK(), (TgtHllType)TgtHllType.valueOf((String)this.getTgtHllType()));
    }
}

