/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authorization.db.updater;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.concurrent.LifecycleLock;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.metadata.MetadataCASUpdate;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.security.basic.BasicAuthCommonCacheConfig;
import org.apache.druid.security.basic.BasicAuthDBConfig;
import org.apache.druid.security.basic.BasicAuthUtils;
import org.apache.druid.security.basic.BasicSecurityDBResourceException;
import org.apache.druid.security.basic.authorization.BasicRoleBasedAuthorizer;
import org.apache.druid.security.basic.authorization.db.cache.BasicAuthorizerCacheNotifier;
import org.apache.druid.security.basic.authorization.db.updater.BasicAuthorizerMetadataStorageUpdater;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerGroupMapping;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerGroupMappingMapBundle;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerPermission;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerRole;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerRoleMapBundle;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerUser;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerUserMapBundle;
import org.apache.druid.security.basic.authorization.entity.GroupMappingAndRoleMap;
import org.apache.druid.security.basic.authorization.entity.UserAndRoleMap;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.server.security.ResourceType;
import org.joda.time.Duration;

@ManageLifecycle
public class CoordinatorBasicAuthorizerMetadataStorageUpdater
implements BasicAuthorizerMetadataStorageUpdater {
    private static final EmittingLogger LOG = new EmittingLogger(CoordinatorBasicAuthorizerMetadataStorageUpdater.class);
    private static final long UPDATE_RETRY_DELAY = 1000L;
    private static final String USERS = "users";
    private static final String GROUP_MAPPINGS = "groupMappings";
    private static final String ROLES = "roles";
    public static final List<ResourceAction> SUPERUSER_PERMISSIONS = CoordinatorBasicAuthorizerMetadataStorageUpdater.makeSuperUserPermissions();
    private final AuthorizerMapper authorizerMapper;
    private final MetadataStorageConnector connector;
    private final MetadataStorageTablesConfig connectorConfig;
    private final BasicAuthorizerCacheNotifier cacheNotifier;
    private final BasicAuthCommonCacheConfig commonCacheConfig;
    private final ObjectMapper objectMapper;
    private final int numRetries = 5;
    private final Map<String, BasicAuthorizerUserMapBundle> cachedUserMaps;
    private final Map<String, BasicAuthorizerGroupMappingMapBundle> cachedGroupMappingMaps;
    private final Map<String, BasicAuthorizerRoleMapBundle> cachedRoleMaps;
    private final Set<String> authorizerNames;
    private final LifecycleLock lifecycleLock = new LifecycleLock();
    private final ScheduledExecutorService exec = Execs.scheduledSingleThreaded((String)"CoordinatorBasicAuthorizerMetadataStorageUpdater-Exec--%d");
    private volatile boolean stopped = false;

    @Inject
    public CoordinatorBasicAuthorizerMetadataStorageUpdater(AuthorizerMapper authorizerMapper, MetadataStorageConnector connector, MetadataStorageTablesConfig connectorConfig, BasicAuthCommonCacheConfig commonCacheConfig, @Smile ObjectMapper objectMapper, BasicAuthorizerCacheNotifier cacheNotifier, ConfigManager configManager) {
        this.authorizerMapper = authorizerMapper;
        this.connector = connector;
        this.connectorConfig = connectorConfig;
        this.commonCacheConfig = commonCacheConfig;
        this.objectMapper = objectMapper;
        this.cacheNotifier = cacheNotifier;
        this.cachedUserMaps = new ConcurrentHashMap<String, BasicAuthorizerUserMapBundle>();
        this.cachedGroupMappingMaps = new ConcurrentHashMap<String, BasicAuthorizerGroupMappingMapBundle>();
        this.cachedRoleMaps = new ConcurrentHashMap<String, BasicAuthorizerRoleMapBundle>();
        this.authorizerNames = new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        if (!this.lifecycleLock.canStart()) {
            throw new ISE("can't start.", new Object[0]);
        }
        if (this.authorizerMapper == null || this.authorizerMapper.getAuthorizerMap() == null) {
            return;
        }
        try {
            LOG.info("Starting CoordinatorBasicAuthorizerMetadataStorageUpdater", new Object[0]);
            for (Map.Entry entry : this.authorizerMapper.getAuthorizerMap().entrySet()) {
                Authorizer authorizer = (Authorizer)entry.getValue();
                if (!(authorizer instanceof BasicRoleBasedAuthorizer)) continue;
                BasicRoleBasedAuthorizer basicRoleBasedAuthorizer = (BasicRoleBasedAuthorizer)authorizer;
                BasicAuthDBConfig dbConfig = basicRoleBasedAuthorizer.getDbConfig();
                String authorizerName = (String)entry.getKey();
                this.authorizerNames.add(authorizerName);
                byte[] userMapBytes = this.getCurrentUserMapBytes(authorizerName);
                Map<String, BasicAuthorizerUser> userMap = BasicAuthUtils.deserializeAuthorizerUserMap(this.objectMapper, userMapBytes);
                this.cachedUserMaps.put(authorizerName, new BasicAuthorizerUserMapBundle(userMap, userMapBytes));
                byte[] groupMappingMapBytes = this.getCurrentGroupMappingMapBytes(authorizerName);
                Map<String, BasicAuthorizerGroupMapping> groupMappingMap = BasicAuthUtils.deserializeAuthorizerGroupMappingMap(this.objectMapper, groupMappingMapBytes);
                this.cachedGroupMappingMaps.put(authorizerName, new BasicAuthorizerGroupMappingMapBundle(groupMappingMap, groupMappingMapBytes));
                byte[] roleMapBytes = this.getCurrentRoleMapBytes(authorizerName);
                Map<String, BasicAuthorizerRole> roleMap = BasicAuthUtils.deserializeAuthorizerRoleMap(this.objectMapper, roleMapBytes);
                this.cachedRoleMaps.put(authorizerName, new BasicAuthorizerRoleMapBundle(roleMap, roleMapBytes));
                this.initSuperUsersAndGroupMapping(authorizerName, userMap, roleMap, groupMappingMap, dbConfig.getInitialAdminUser(), dbConfig.getInitialAdminRole(), dbConfig.getInitialAdminGroupMapping());
            }
            ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)new Duration(this.commonCacheConfig.getPollingPeriod()), (Duration)new Duration(this.commonCacheConfig.getPollingPeriod()), () -> {
                if (this.stopped) {
                    return ScheduledExecutors.Signal.STOP;
                }
                try {
                    LOG.debug("Scheduled db poll is running", new Object[0]);
                    for (String authorizerName : this.authorizerNames) {
                        byte[] userMapBytes = this.getCurrentUserMapBytes(authorizerName);
                        Map<String, BasicAuthorizerUser> userMap = BasicAuthUtils.deserializeAuthorizerUserMap(this.objectMapper, userMapBytes);
                        if (userMapBytes != null) {
                            Map<String, BasicAuthorizerUserMapBundle> map = this.cachedUserMaps;
                            synchronized (map) {
                                this.cachedUserMaps.put(authorizerName, new BasicAuthorizerUserMapBundle(userMap, userMapBytes));
                            }
                        }
                        byte[] groupMappingMapBytes = this.getCurrentGroupMappingMapBytes(authorizerName);
                        Map<String, BasicAuthorizerGroupMapping> groupMappingMap = BasicAuthUtils.deserializeAuthorizerGroupMappingMap(this.objectMapper, groupMappingMapBytes);
                        if (groupMappingMapBytes != null) {
                            Map<String, BasicAuthorizerGroupMappingMapBundle> map = this.cachedGroupMappingMaps;
                            synchronized (map) {
                                this.cachedGroupMappingMaps.put(authorizerName, new BasicAuthorizerGroupMappingMapBundle(groupMappingMap, groupMappingMapBytes));
                            }
                        }
                        byte[] roleMapBytes = this.getCurrentRoleMapBytes(authorizerName);
                        Map<String, BasicAuthorizerRole> roleMap = BasicAuthUtils.deserializeAuthorizerRoleMap(this.objectMapper, roleMapBytes);
                        if (roleMapBytes == null) continue;
                        Map<String, BasicAuthorizerRoleMapBundle> map = this.cachedRoleMaps;
                        synchronized (map) {
                            this.cachedRoleMaps.put(authorizerName, new BasicAuthorizerRoleMapBundle(roleMap, roleMapBytes));
                        }
                    }
                    LOG.debug("Scheduled db poll is done", new Object[0]);
                }
                catch (Throwable t) {
                    LOG.makeAlert(t, "Error occured while polling for cachedUserMaps, cachedGroupMappingMaps, cachedRoleMaps.", new Object[0]).emit();
                }
                return ScheduledExecutors.Signal.REPEAT;
            });
            this.lifecycleLock.started();
        }
        finally {
            this.lifecycleLock.exitStart();
        }
    }

    @LifecycleStop
    public void stop() {
        if (!this.lifecycleLock.canStop()) {
            throw new ISE("can't stop.", new Object[0]);
        }
        LOG.info("CoordinatorBasicAuthorizerMetadataStorageUpdater is stopping.", new Object[0]);
        this.stopped = true;
        LOG.info("CoordinatorBasicAuthorizerMetadataStorageUpdater is stopped.", new Object[0]);
    }

    private static String getPrefixedKeyColumn(String keyPrefix, String keyName) {
        return StringUtils.format((String)"basic_authorization_%s_%s", (Object[])new Object[]{keyPrefix, keyName});
    }

    private boolean tryUpdateUserMap(String prefix, Map<String, BasicAuthorizerUser> userMap, byte[] oldUserMapValue, byte[] newUserMapValue) {
        try {
            ArrayList<MetadataCASUpdate> updates = new ArrayList<MetadataCASUpdate>();
            if (userMap != null) {
                updates.add(this.createMetadataCASUpdate(prefix, oldUserMapValue, newUserMapValue, USERS));
                boolean succeeded = this.connector.compareAndSwap(updates);
                if (succeeded) {
                    this.cachedUserMaps.put(prefix, new BasicAuthorizerUserMapBundle(userMap, newUserMapValue));
                    byte[] serializedUserAndRoleMap = this.getCurrentUserAndRoleMapSerialized(prefix);
                    this.cacheNotifier.addUpdateUser(prefix, serializedUserAndRoleMap);
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean tryUpdateGroupMappingMap(String prefix, Map<String, BasicAuthorizerGroupMapping> groupMappingMap, byte[] oldGroupMappingMapValue, byte[] newGroupMappingMapValue) {
        try {
            ArrayList<MetadataCASUpdate> updates = new ArrayList<MetadataCASUpdate>();
            if (groupMappingMap != null) {
                updates.add(this.createMetadataCASUpdate(prefix, oldGroupMappingMapValue, newGroupMappingMapValue, GROUP_MAPPINGS));
                boolean succeeded = this.connector.compareAndSwap(updates);
                if (succeeded) {
                    this.cachedGroupMappingMaps.put(prefix, new BasicAuthorizerGroupMappingMapBundle(groupMappingMap, newGroupMappingMapValue));
                    byte[] serializedGroupMappingAndRoleMap = this.getCurrentGroupMappingAndRoleMapSerialized(prefix);
                    this.cacheNotifier.addUpdateGroupMapping(prefix, serializedGroupMappingAndRoleMap);
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean tryUpdateRoleMap(String prefix, Map<String, BasicAuthorizerRole> roleMap, byte[] oldRoleMapValue, byte[] newRoleMapValue) {
        try {
            ArrayList<MetadataCASUpdate> updates = new ArrayList<MetadataCASUpdate>();
            if (roleMap != null) {
                updates.add(this.createMetadataCASUpdate(prefix, oldRoleMapValue, newRoleMapValue, ROLES));
                boolean succeeded = this.connector.compareAndSwap(updates);
                if (succeeded) {
                    this.cachedRoleMaps.put(prefix, new BasicAuthorizerRoleMapBundle(roleMap, newRoleMapValue));
                    byte[] serializedUserAndRoleMap = this.getCurrentUserAndRoleMapSerialized(prefix);
                    this.cacheNotifier.addUpdateUser(prefix, serializedUserAndRoleMap);
                    byte[] serializedGroupMappingAndRoleMap = this.getCurrentGroupMappingAndRoleMapSerialized(prefix);
                    this.cacheNotifier.addUpdateGroupMapping(prefix, serializedGroupMappingAndRoleMap);
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean tryUpdateUserAndRoleMap(String prefix, Map<String, BasicAuthorizerUser> userMap, byte[] oldUserMapValue, byte[] newUserMapValue, Map<String, BasicAuthorizerRole> roleMap, byte[] oldRoleMapValue, byte[] newRoleMapValue) {
        try {
            ArrayList<MetadataCASUpdate> updates = new ArrayList<MetadataCASUpdate>();
            if (userMap != null && roleMap != null) {
                updates.add(this.createMetadataCASUpdate(prefix, oldUserMapValue, newUserMapValue, USERS));
                updates.add(this.createMetadataCASUpdate(prefix, oldRoleMapValue, newRoleMapValue, ROLES));
                boolean succeeded = this.connector.compareAndSwap(updates);
                if (succeeded) {
                    this.cachedUserMaps.put(prefix, new BasicAuthorizerUserMapBundle(userMap, newUserMapValue));
                    this.cachedRoleMaps.put(prefix, new BasicAuthorizerRoleMapBundle(roleMap, newRoleMapValue));
                    byte[] serializedUserAndRoleMap = this.getCurrentUserAndRoleMapSerialized(prefix);
                    this.cacheNotifier.addUpdateUser(prefix, serializedUserAndRoleMap);
                    return true;
                }
                return false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    private boolean tryUpdateGroupMappingAndRoleMap(String prefix, Map<String, BasicAuthorizerGroupMapping> groupMappingMap, byte[] oldGroupMappingMapValue, byte[] newGroupMappingMapValue, Map<String, BasicAuthorizerRole> roleMap, byte[] oldRoleMapValue, byte[] newRoleMapValue) {
        try {
            boolean succeeded;
            ArrayList<MetadataCASUpdate> updates = new ArrayList<MetadataCASUpdate>();
            if (groupMappingMap != null && roleMap != null) {
                updates.add(this.createMetadataCASUpdate(prefix, oldGroupMappingMapValue, newGroupMappingMapValue, GROUP_MAPPINGS));
                updates.add(this.createMetadataCASUpdate(prefix, oldRoleMapValue, newRoleMapValue, ROLES));
            }
            if (succeeded = this.connector.compareAndSwap(updates)) {
                this.cachedGroupMappingMaps.put(prefix, new BasicAuthorizerGroupMappingMapBundle(groupMappingMap, newGroupMappingMapValue));
                this.cachedRoleMaps.put(prefix, new BasicAuthorizerRoleMapBundle(roleMap, newRoleMapValue));
                byte[] serializedGroupMappingAndRoleMap = this.getCurrentGroupMappingAndRoleMapSerialized(prefix);
                this.cacheNotifier.addUpdateGroupMapping(prefix, serializedGroupMappingAndRoleMap);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    private MetadataCASUpdate createMetadataCASUpdate(String prefix, byte[] oldValue, byte[] newValue, String columnName) {
        return new MetadataCASUpdate(this.connectorConfig.getConfigTable(), "name", "payload", CoordinatorBasicAuthorizerMetadataStorageUpdater.getPrefixedKeyColumn(prefix, columnName), oldValue, newValue);
    }

    @Override
    public void createUser(String prefix, String userName) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        this.createUserInternal(prefix, userName);
    }

    @Override
    public void deleteUser(String prefix, String userName) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        this.deleteUserInternal(prefix, userName);
    }

    @Override
    public void createGroupMapping(String prefix, BasicAuthorizerGroupMapping groupMapping) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        this.createGroupMappingInternal(prefix, groupMapping);
    }

    @Override
    public void deleteGroupMapping(String prefix, String groupMappingName) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        this.deleteGroupMappingInternal(prefix, groupMappingName);
    }

    @Override
    public void createRole(String prefix, String roleName) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        this.createRoleInternal(prefix, roleName);
    }

    @Override
    public void deleteRole(String prefix, String roleName) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        this.deleteRoleInternal(prefix, roleName);
    }

    @Override
    public void assignUserRole(String prefix, String userName, String roleName) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        this.assignUserRoleInternal(prefix, userName, roleName);
    }

    @Override
    public void unassignUserRole(String prefix, String userName, String roleName) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        this.unassignUserRoleInternal(prefix, userName, roleName);
    }

    @Override
    public void assignGroupMappingRole(String prefix, String groupMappingName, String roleName) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        this.assignGroupMappingRoleInternal(prefix, groupMappingName, roleName);
    }

    @Override
    public void unassignGroupMappingRole(String prefix, String groupMappingName, String roleName) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        this.unassignGroupMappingRoleInternal(prefix, groupMappingName, roleName);
    }

    @Override
    public void setPermissions(String prefix, String roleName, List<ResourceAction> permissions) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        this.setPermissionsInternal(prefix, roleName, permissions);
    }

    @Override
    @Nullable
    public Map<String, BasicAuthorizerUser> getCachedUserMap(String prefix) {
        BasicAuthorizerUserMapBundle userMapBundle = this.cachedUserMaps.get(prefix);
        return userMapBundle == null ? null : userMapBundle.getUserMap();
    }

    @Override
    public Map<String, BasicAuthorizerGroupMapping> getCachedGroupMappingMap(String prefix) {
        BasicAuthorizerGroupMappingMapBundle groupMapBundle = this.cachedGroupMappingMaps.get(prefix);
        return groupMapBundle == null ? null : groupMapBundle.getGroupMappingMap();
    }

    @Override
    @Nullable
    public Map<String, BasicAuthorizerRole> getCachedRoleMap(String prefix) {
        BasicAuthorizerRoleMapBundle roleMapBundle = this.cachedRoleMaps.get(prefix);
        return roleMapBundle == null ? null : roleMapBundle.getRoleMap();
    }

    @Override
    public byte[] getCurrentUserMapBytes(String prefix) {
        return this.connector.lookup(this.connectorConfig.getConfigTable(), "name", "payload", CoordinatorBasicAuthorizerMetadataStorageUpdater.getPrefixedKeyColumn(prefix, USERS));
    }

    @Override
    public byte[] getCurrentGroupMappingMapBytes(String prefix) {
        return this.connector.lookup(this.connectorConfig.getConfigTable(), "name", "payload", CoordinatorBasicAuthorizerMetadataStorageUpdater.getPrefixedKeyColumn(prefix, GROUP_MAPPINGS));
    }

    @Override
    public byte[] getCurrentRoleMapBytes(String prefix) {
        return this.connector.lookup(this.connectorConfig.getConfigTable(), "name", "payload", CoordinatorBasicAuthorizerMetadataStorageUpdater.getPrefixedKeyColumn(prefix, ROLES));
    }

    @Override
    public void refreshAllNotification() {
        this.authorizerNames.forEach(authorizerName -> {
            try {
                byte[] serializedUserAndRoleMap = this.getCurrentUserAndRoleMapSerialized((String)authorizerName);
                this.cacheNotifier.addUpdateUser((String)authorizerName, serializedUserAndRoleMap);
                byte[] serializeGroupAndRoleMap = this.getCurrentGroupMappingAndRoleMapSerialized((String)authorizerName);
                this.cacheNotifier.addUpdateGroupMapping((String)authorizerName, serializeGroupAndRoleMap);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        });
    }

    private byte[] getCurrentUserAndRoleMapSerialized(String prefix) throws IOException {
        BasicAuthorizerUserMapBundle userMapBundle = this.cachedUserMaps.get(prefix);
        BasicAuthorizerRoleMapBundle roleMapBundle = this.cachedRoleMaps.get(prefix);
        UserAndRoleMap userAndRoleMap = new UserAndRoleMap(userMapBundle == null ? null : userMapBundle.getUserMap(), roleMapBundle == null ? null : roleMapBundle.getRoleMap());
        return this.objectMapper.writeValueAsBytes((Object)userAndRoleMap);
    }

    private byte[] getCurrentGroupMappingAndRoleMapSerialized(String prefix) throws IOException {
        BasicAuthorizerGroupMappingMapBundle groupMappingMapBundle = this.cachedGroupMappingMaps.get(prefix);
        BasicAuthorizerRoleMapBundle roleMapBundle = this.cachedRoleMaps.get(prefix);
        GroupMappingAndRoleMap groupMappingAndRoleMap = new GroupMappingAndRoleMap(groupMappingMapBundle == null ? null : groupMappingMapBundle.getGroupMappingMap(), roleMapBundle == null ? null : roleMapBundle.getRoleMap());
        return this.objectMapper.writeValueAsBytes((Object)groupMappingAndRoleMap);
    }

    private void createUserInternal(String prefix, String userName) {
        for (int attempts = 0; attempts < 5; ++attempts) {
            if (this.createUserOnce(prefix, userName)) {
                return;
            }
            try {
                Thread.sleep(ThreadLocalRandom.current().nextLong(1000L));
                continue;
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
        throw new ISE("Could not create user [%s] due to concurrent update contention.", new Object[]{userName});
    }

    private void deleteUserInternal(String prefix, String userName) {
        for (int attempts = 0; attempts < 5; ++attempts) {
            if (this.deleteUserOnce(prefix, userName)) {
                return;
            }
            try {
                Thread.sleep(ThreadLocalRandom.current().nextLong(1000L));
                continue;
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
        throw new ISE("Could not delete user [%s] due to concurrent update contention.", new Object[]{userName});
    }

    private void createGroupMappingInternal(String prefix, BasicAuthorizerGroupMapping groupMapping) {
        for (int attempts = 0; attempts < 5; ++attempts) {
            if (this.createGroupMappingOnce(prefix, groupMapping)) {
                return;
            }
            try {
                Thread.sleep(ThreadLocalRandom.current().nextLong(1000L));
                continue;
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
        throw new ISE("Could not create group mapping [%s] due to concurrent update contention.", new Object[]{groupMapping});
    }

    private void deleteGroupMappingInternal(String prefix, String groupMappingName) {
        for (int attempts = 0; attempts < 5; ++attempts) {
            if (this.deleteGroupMappingOnce(prefix, groupMappingName)) {
                return;
            }
            try {
                Thread.sleep(ThreadLocalRandom.current().nextLong(1000L));
                continue;
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
        throw new ISE("Could not delete group mapping [%s] due to concurrent update contention.", new Object[]{groupMappingName});
    }

    private void createRoleInternal(String prefix, String roleName) {
        for (int attempts = 0; attempts < 5; ++attempts) {
            if (this.createRoleOnce(prefix, roleName)) {
                return;
            }
            try {
                Thread.sleep(ThreadLocalRandom.current().nextLong(1000L));
                continue;
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
        throw new ISE("Could not create role [%s] due to concurrent update contention.", new Object[]{roleName});
    }

    private void deleteRoleInternal(String prefix, String roleName) {
        for (int attempts = 0; attempts < 5; ++attempts) {
            if (this.deleteRoleOnce(prefix, roleName)) {
                return;
            }
            try {
                Thread.sleep(ThreadLocalRandom.current().nextLong(1000L));
                continue;
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
        throw new ISE("Could not delete role [%s] due to concurrent update contention.", new Object[]{roleName});
    }

    private void assignUserRoleInternal(String prefix, String userName, String roleName) {
        for (int attempts = 0; attempts < 5; ++attempts) {
            if (this.assignUserRoleOnce(prefix, userName, roleName)) {
                return;
            }
            try {
                Thread.sleep(ThreadLocalRandom.current().nextLong(1000L));
                continue;
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
        throw new ISE("Could not assign role [%s] to user [%s] due to concurrent update contention.", new Object[]{roleName, userName});
    }

    private void unassignUserRoleInternal(String prefix, String userName, String roleName) {
        for (int attempts = 0; attempts < 5; ++attempts) {
            if (this.unassignUserRoleOnce(prefix, userName, roleName)) {
                return;
            }
            try {
                Thread.sleep(ThreadLocalRandom.current().nextLong(1000L));
                continue;
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
        throw new ISE("Could not unassign role [%s] from user [%s] due to concurrent update contention.", new Object[]{roleName, userName});
    }

    private void assignGroupMappingRoleInternal(String prefix, String groupMappingName, String roleName) {
        for (int attempts = 0; attempts < 5; ++attempts) {
            if (this.assignGroupMappingRoleOnce(prefix, groupMappingName, roleName)) {
                return;
            }
            try {
                Thread.sleep(ThreadLocalRandom.current().nextLong(1000L));
                continue;
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
        throw new ISE("Could not assign role [%s] to group mapping [%s] due to concurrent update contention.", new Object[]{roleName, groupMappingName});
    }

    private void unassignGroupMappingRoleInternal(String prefix, String groupMappingName, String roleName) {
        for (int attempts = 0; attempts < 5; ++attempts) {
            if (this.unassignGroupMappingRoleOnce(prefix, groupMappingName, roleName)) {
                return;
            }
            try {
                Thread.sleep(ThreadLocalRandom.current().nextLong(1000L));
                continue;
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
        throw new ISE("Could not unassign role [%s] from group mapping [%s] due to concurrent update contention.", new Object[]{roleName, groupMappingName});
    }

    private void setPermissionsInternal(String prefix, String roleName, List<ResourceAction> permissions) {
        for (int attempts = 0; attempts < 5; ++attempts) {
            if (this.setPermissionsOnce(prefix, roleName, permissions)) {
                return;
            }
            try {
                Thread.sleep(ThreadLocalRandom.current().nextLong(1000L));
                continue;
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
        throw new ISE("Could not set permissions for role [%s] due to concurrent update contention.", new Object[]{roleName});
    }

    private boolean deleteUserOnce(String prefix, String userName) {
        byte[] oldValue = this.getCurrentUserMapBytes(prefix);
        Map<String, BasicAuthorizerUser> userMap = BasicAuthUtils.deserializeAuthorizerUserMap(this.objectMapper, oldValue);
        if (userMap.get(userName) == null) {
            throw new BasicSecurityDBResourceException("User [%s] does not exist.", userName);
        }
        userMap.remove(userName);
        byte[] newValue = BasicAuthUtils.serializeAuthorizerUserMap(this.objectMapper, userMap);
        return this.tryUpdateUserMap(prefix, userMap, oldValue, newValue);
    }

    private boolean createUserOnce(String prefix, String userName) {
        byte[] oldValue = this.getCurrentUserMapBytes(prefix);
        Map<String, BasicAuthorizerUser> userMap = BasicAuthUtils.deserializeAuthorizerUserMap(this.objectMapper, oldValue);
        if (userMap.get(userName) != null) {
            throw new BasicSecurityDBResourceException("User [%s] already exists.", userName);
        }
        userMap.put(userName, new BasicAuthorizerUser(userName, null));
        byte[] newValue = BasicAuthUtils.serializeAuthorizerUserMap(this.objectMapper, userMap);
        return this.tryUpdateUserMap(prefix, userMap, oldValue, newValue);
    }

    private boolean deleteGroupMappingOnce(String prefix, String groupMappingName) {
        byte[] oldValue = this.getCurrentGroupMappingMapBytes(prefix);
        Map<String, BasicAuthorizerGroupMapping> groupMappingMap = BasicAuthUtils.deserializeAuthorizerGroupMappingMap(this.objectMapper, oldValue);
        if (groupMappingMap.get(groupMappingName) == null) {
            throw new BasicSecurityDBResourceException("Group mapping [%s] does not exist.", groupMappingName);
        }
        groupMappingMap.remove(groupMappingName);
        byte[] newValue = BasicAuthUtils.serializeAuthorizerGroupMappingMap(this.objectMapper, groupMappingMap);
        return this.tryUpdateGroupMappingMap(prefix, groupMappingMap, oldValue, newValue);
    }

    private boolean createGroupMappingOnce(String prefix, BasicAuthorizerGroupMapping groupMapping) {
        byte[] oldValue = this.getCurrentGroupMappingMapBytes(prefix);
        Map<String, BasicAuthorizerGroupMapping> groupMappingMap = BasicAuthUtils.deserializeAuthorizerGroupMappingMap(this.objectMapper, oldValue);
        if (groupMappingMap.get(groupMapping.getName()) != null) {
            throw new BasicSecurityDBResourceException("Group mapping [%s] already exists.", groupMapping.getName());
        }
        groupMappingMap.put(groupMapping.getName(), groupMapping);
        byte[] newValue = BasicAuthUtils.serializeAuthorizerGroupMappingMap(this.objectMapper, groupMappingMap);
        return this.tryUpdateGroupMappingMap(prefix, groupMappingMap, oldValue, newValue);
    }

    private boolean createRoleOnce(String prefix, String roleName) {
        byte[] oldValue = this.getCurrentRoleMapBytes(prefix);
        Map<String, BasicAuthorizerRole> roleMap = BasicAuthUtils.deserializeAuthorizerRoleMap(this.objectMapper, oldValue);
        if (roleMap.get(roleName) != null) {
            throw new BasicSecurityDBResourceException("Role [%s] already exists.", roleName);
        }
        roleMap.put(roleName, new BasicAuthorizerRole(roleName, null));
        byte[] newValue = BasicAuthUtils.serializeAuthorizerRoleMap(this.objectMapper, roleMap);
        return this.tryUpdateRoleMap(prefix, roleMap, oldValue, newValue);
    }

    private boolean deleteRoleOnce(String prefix, String roleName) {
        byte[] oldRoleMapValue = this.getCurrentRoleMapBytes(prefix);
        Map<String, BasicAuthorizerRole> roleMap = BasicAuthUtils.deserializeAuthorizerRoleMap(this.objectMapper, oldRoleMapValue);
        if (roleMap.get(roleName) == null) {
            throw new BasicSecurityDBResourceException("Role [%s] does not exist.", roleName);
        }
        roleMap.remove(roleName);
        byte[] oldUserMapValue = this.getCurrentUserMapBytes(prefix);
        Map<String, BasicAuthorizerUser> userMap = BasicAuthUtils.deserializeAuthorizerUserMap(this.objectMapper, oldUserMapValue);
        for (BasicAuthorizerUser user : userMap.values()) {
            user.getRoles().remove(roleName);
        }
        byte[] newUserMapValue = BasicAuthUtils.serializeAuthorizerUserMap(this.objectMapper, userMap);
        byte[] oldGroupMapValue = this.getCurrentGroupMappingMapBytes(prefix);
        Map<String, BasicAuthorizerGroupMapping> groupMap = BasicAuthUtils.deserializeAuthorizerGroupMappingMap(this.objectMapper, oldGroupMapValue);
        for (BasicAuthorizerGroupMapping group : groupMap.values()) {
            group.getRoles().remove(roleName);
        }
        byte[] newGroupMapValue = BasicAuthUtils.serializeAuthorizerGroupMappingMap(this.objectMapper, groupMap);
        byte[] newRoleMapValue = BasicAuthUtils.serializeAuthorizerRoleMap(this.objectMapper, roleMap);
        return this.tryUpdateUserAndRoleMap(prefix, userMap, oldUserMapValue, newUserMapValue, roleMap, oldRoleMapValue, newRoleMapValue) && this.tryUpdateGroupMappingAndRoleMap(prefix, groupMap, oldGroupMapValue, newGroupMapValue, roleMap, newRoleMapValue, newRoleMapValue);
    }

    private boolean assignUserRoleOnce(String prefix, String userName, String roleName) {
        byte[] oldRoleMapValue = this.getCurrentRoleMapBytes(prefix);
        Map<String, BasicAuthorizerRole> roleMap = BasicAuthUtils.deserializeAuthorizerRoleMap(this.objectMapper, oldRoleMapValue);
        if (roleMap.get(roleName) == null) {
            throw new BasicSecurityDBResourceException("Role [%s] does not exist.", roleName);
        }
        byte[] oldUserMapValue = this.getCurrentUserMapBytes(prefix);
        Map<String, BasicAuthorizerUser> userMap = BasicAuthUtils.deserializeAuthorizerUserMap(this.objectMapper, oldUserMapValue);
        BasicAuthorizerUser user = userMap.get(userName);
        if (userMap.get(userName) == null) {
            throw new BasicSecurityDBResourceException("User [%s] does not exist.", userName);
        }
        if (user.getRoles().contains(roleName)) {
            throw new BasicSecurityDBResourceException("User [%s] already has role [%s].", userName, roleName);
        }
        user.getRoles().add(roleName);
        byte[] newUserMapValue = BasicAuthUtils.serializeAuthorizerUserMap(this.objectMapper, userMap);
        return this.tryUpdateUserAndRoleMap(prefix, userMap, oldUserMapValue, newUserMapValue, roleMap, oldRoleMapValue, oldRoleMapValue);
    }

    private boolean unassignUserRoleOnce(String prefix, String userName, String roleName) {
        byte[] oldRoleMapValue = this.getCurrentRoleMapBytes(prefix);
        Map<String, BasicAuthorizerRole> roleMap = BasicAuthUtils.deserializeAuthorizerRoleMap(this.objectMapper, oldRoleMapValue);
        if (roleMap.get(roleName) == null) {
            throw new BasicSecurityDBResourceException("Role [%s] does not exist.", roleName);
        }
        byte[] oldUserMapValue = this.getCurrentUserMapBytes(prefix);
        Map<String, BasicAuthorizerUser> userMap = BasicAuthUtils.deserializeAuthorizerUserMap(this.objectMapper, oldUserMapValue);
        BasicAuthorizerUser user = userMap.get(userName);
        if (userMap.get(userName) == null) {
            throw new BasicSecurityDBResourceException("User [%s] does not exist.", userName);
        }
        if (!user.getRoles().contains(roleName)) {
            throw new BasicSecurityDBResourceException("User [%s] does not have role [%s].", userName, roleName);
        }
        user.getRoles().remove(roleName);
        byte[] newUserMapValue = BasicAuthUtils.serializeAuthorizerUserMap(this.objectMapper, userMap);
        return this.tryUpdateUserAndRoleMap(prefix, userMap, oldUserMapValue, newUserMapValue, roleMap, oldRoleMapValue, oldRoleMapValue);
    }

    private boolean assignGroupMappingRoleOnce(String prefix, String groupMappingName, String roleName) {
        byte[] oldRoleMapValue = this.getCurrentRoleMapBytes(prefix);
        Map<String, BasicAuthorizerRole> roleMap = BasicAuthUtils.deserializeAuthorizerRoleMap(this.objectMapper, oldRoleMapValue);
        if (roleMap.get(roleName) == null) {
            throw new BasicSecurityDBResourceException("Role [%s] does not exist.", roleName);
        }
        byte[] oldGroupMappingMapValue = this.getCurrentGroupMappingMapBytes(prefix);
        Map<String, BasicAuthorizerGroupMapping> groupMappingMap = BasicAuthUtils.deserializeAuthorizerGroupMappingMap(this.objectMapper, oldGroupMappingMapValue);
        BasicAuthorizerGroupMapping groupMapping = groupMappingMap.get(groupMappingName);
        if (groupMappingMap.get(groupMappingName) == null) {
            throw new BasicSecurityDBResourceException("Group mapping [%s] does not exist.", groupMappingName);
        }
        if (groupMapping.getRoles().contains(roleName)) {
            throw new BasicSecurityDBResourceException("Group mapping [%s] already has role [%s].", groupMappingName, roleName);
        }
        groupMapping.getRoles().add(roleName);
        byte[] newGroupMapValue = BasicAuthUtils.serializeAuthorizerGroupMappingMap(this.objectMapper, groupMappingMap);
        return this.tryUpdateGroupMappingAndRoleMap(prefix, groupMappingMap, oldGroupMappingMapValue, newGroupMapValue, roleMap, oldRoleMapValue, oldRoleMapValue);
    }

    private boolean unassignGroupMappingRoleOnce(String prefix, String groupMappingName, String roleName) {
        byte[] oldRoleMapValue = this.getCurrentRoleMapBytes(prefix);
        Map<String, BasicAuthorizerRole> roleMap = BasicAuthUtils.deserializeAuthorizerRoleMap(this.objectMapper, oldRoleMapValue);
        if (roleMap.get(roleName) == null) {
            throw new BasicSecurityDBResourceException("Role [%s] does not exist.", roleName);
        }
        byte[] oldGroupMappingMapValue = this.getCurrentGroupMappingMapBytes(prefix);
        Map<String, BasicAuthorizerGroupMapping> groupMappingMap = BasicAuthUtils.deserializeAuthorizerGroupMappingMap(this.objectMapper, oldGroupMappingMapValue);
        BasicAuthorizerGroupMapping groupMapping = groupMappingMap.get(groupMappingName);
        if (groupMappingMap.get(groupMappingName) == null) {
            throw new BasicSecurityDBResourceException("Group mapping [%s] does not exist.", groupMappingName);
        }
        if (!groupMapping.getRoles().contains(roleName)) {
            throw new BasicSecurityDBResourceException("Group mapping [%s] does not have role [%s].", groupMappingName, roleName);
        }
        groupMapping.getRoles().remove(roleName);
        byte[] newGroupMapValue = BasicAuthUtils.serializeAuthorizerGroupMappingMap(this.objectMapper, groupMappingMap);
        return this.tryUpdateGroupMappingAndRoleMap(prefix, groupMappingMap, oldGroupMappingMapValue, newGroupMapValue, roleMap, oldRoleMapValue, oldRoleMapValue);
    }

    private boolean setPermissionsOnce(String prefix, String roleName, List<ResourceAction> permissions) {
        byte[] oldRoleMapValue = this.getCurrentRoleMapBytes(prefix);
        Map<String, BasicAuthorizerRole> roleMap = BasicAuthUtils.deserializeAuthorizerRoleMap(this.objectMapper, oldRoleMapValue);
        if (roleMap.get(roleName) == null) {
            throw new BasicSecurityDBResourceException("Role [%s] does not exist.", roleName);
        }
        roleMap.put(roleName, new BasicAuthorizerRole(roleName, BasicAuthorizerPermission.makePermissionList(permissions)));
        byte[] newRoleMapValue = BasicAuthUtils.serializeAuthorizerRoleMap(this.objectMapper, roleMap);
        return this.tryUpdateRoleMap(prefix, roleMap, oldRoleMapValue, newRoleMapValue);
    }

    private void initSuperUsersAndGroupMapping(String authorizerName, Map<String, BasicAuthorizerUser> userMap, Map<String, BasicAuthorizerRole> roleMap, Map<String, BasicAuthorizerGroupMapping> groupMappingMap, String initialAdminUser, String initialAdminRole, String initialAdminGroupMapping) {
        if (!roleMap.containsKey("admin")) {
            this.createRoleInternal(authorizerName, "admin");
            this.setPermissionsInternal(authorizerName, "admin", SUPERUSER_PERMISSIONS);
        }
        if (!roleMap.containsKey("druid_system")) {
            this.createRoleInternal(authorizerName, "druid_system");
            this.setPermissionsInternal(authorizerName, "druid_system", SUPERUSER_PERMISSIONS);
        }
        if (!userMap.containsKey("admin")) {
            this.createUserInternal(authorizerName, "admin");
            this.assignUserRoleInternal(authorizerName, "admin", "admin");
        }
        if (!userMap.containsKey("druid_system")) {
            this.createUserInternal(authorizerName, "druid_system");
            this.assignUserRoleInternal(authorizerName, "druid_system", "druid_system");
        }
        if (!(initialAdminRole == null || initialAdminRole.equals("admin") || initialAdminRole.equals("druid_system") || roleMap.containsKey(initialAdminRole))) {
            this.createRoleInternal(authorizerName, initialAdminRole);
            this.setPermissionsInternal(authorizerName, initialAdminRole, SUPERUSER_PERMISSIONS);
        }
        if (!(initialAdminUser == null || initialAdminUser.equals("admin") || initialAdminUser.equals("druid_system") || userMap.containsKey(initialAdminUser))) {
            this.createUserInternal(authorizerName, initialAdminUser);
            this.assignUserRoleInternal(authorizerName, initialAdminUser, initialAdminRole == null ? "admin" : initialAdminRole);
        }
        if (initialAdminGroupMapping != null && !groupMappingMap.containsKey("adminGroupMapping")) {
            BasicAuthorizerGroupMapping groupMapping = new BasicAuthorizerGroupMapping("adminGroupMapping", initialAdminGroupMapping, new HashSet<String>(Collections.singletonList(initialAdminRole == null ? "admin" : initialAdminRole)));
            this.createGroupMappingInternal(authorizerName, groupMapping);
        }
    }

    private static List<ResourceAction> makeSuperUserPermissions() {
        ResourceAction datasourceR = new ResourceAction(new Resource(".*", ResourceType.DATASOURCE), Action.READ);
        ResourceAction datasourceW = new ResourceAction(new Resource(".*", ResourceType.DATASOURCE), Action.WRITE);
        ResourceAction configR = new ResourceAction(new Resource(".*", ResourceType.CONFIG), Action.READ);
        ResourceAction configW = new ResourceAction(new Resource(".*", ResourceType.CONFIG), Action.WRITE);
        ResourceAction stateR = new ResourceAction(new Resource(".*", ResourceType.STATE), Action.READ);
        ResourceAction stateW = new ResourceAction(new Resource(".*", ResourceType.STATE), Action.WRITE);
        return Lists.newArrayList((Object[])new ResourceAction[]{datasourceR, datasourceW, configR, configW, stateR, stateW});
    }
}

