/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authentication.validator;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.inject.Provider;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.security.basic.BasicAuthUtils;
import org.apache.druid.security.basic.BasicSecurityAuthenticationException;
import org.apache.druid.security.basic.authentication.db.cache.BasicAuthenticatorCacheManager;
import org.apache.druid.security.basic.authentication.entity.BasicAuthenticatorCredentials;
import org.apache.druid.security.basic.authentication.entity.BasicAuthenticatorUser;
import org.apache.druid.security.basic.authentication.validator.CredentialsValidator;
import org.apache.druid.server.security.AuthenticationResult;

@JsonTypeName(value="metadata")
public class MetadataStoreCredentialsValidator
implements CredentialsValidator {
    private static final Logger LOG = new Logger(MetadataStoreCredentialsValidator.class);
    private final Provider<BasicAuthenticatorCacheManager> cacheManager;

    @JsonCreator
    public MetadataStoreCredentialsValidator(@JacksonInject Provider<BasicAuthenticatorCacheManager> cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    @Nullable
    public AuthenticationResult validateCredentials(String authenticatorName, String authorizerName, String username, char[] password) {
        Map<String, BasicAuthenticatorUser> userMap = ((BasicAuthenticatorCacheManager)this.cacheManager.get()).getUserMap(authenticatorName);
        if (userMap == null) {
            throw new IAE("No userMap is available for authenticator with prefix: [%s]", new Object[]{authenticatorName});
        }
        BasicAuthenticatorUser user = userMap.get(username);
        if (user == null) {
            return null;
        }
        BasicAuthenticatorCredentials credentials = user.getCredentials();
        if (credentials == null) {
            return null;
        }
        byte[] recalculatedHash = BasicAuthUtils.hashPassword(password, credentials.getSalt(), credentials.getIterations());
        if (Arrays.equals(recalculatedHash, credentials.getHash())) {
            return new AuthenticationResult(username, authorizerName, authenticatorName, null);
        }
        LOG.debug("Password incorrect for metadata store user %s", new Object[]{username});
        throw new BasicSecurityAuthenticationException("User metadata store authentication failed.", new Object[0]);
    }
}

