/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.avro;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.util.ByteBufferInputStream;
import org.apache.druid.data.input.avro.AvroBytesDecoder;
import org.apache.druid.data.input.schemarepo.SubjectAndIdConverter;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.schemarepo.Repository;
import org.schemarepo.api.TypedSchemaRepository;
import org.schemarepo.api.converter.AvroSchemaConverter;
import org.schemarepo.api.converter.Converter;

public class SchemaRepoBasedAvroBytesDecoder<SUBJECT, ID>
implements AvroBytesDecoder {
    private final TypedSchemaRepository<ID, Schema, SUBJECT> typedRepository;
    private final SubjectAndIdConverter<SUBJECT, ID> subjectAndIdConverter;
    private final Repository schemaRepository;

    @JsonCreator
    public SchemaRepoBasedAvroBytesDecoder(@JsonProperty(value="subjectAndIdConverter") SubjectAndIdConverter<SUBJECT, ID> subjectAndIdConverter, @JsonProperty(value="schemaRepository") Repository schemaRepository) {
        this.subjectAndIdConverter = subjectAndIdConverter;
        this.schemaRepository = schemaRepository;
        this.typedRepository = new TypedSchemaRepository(schemaRepository, subjectAndIdConverter.getIdConverter(), (Converter)new AvroSchemaConverter(Boolean.valueOf(false)), subjectAndIdConverter.getSubjectConverter());
    }

    @JsonProperty
    public Repository getSchemaRepository() {
        return this.schemaRepository;
    }

    @JsonProperty
    public SubjectAndIdConverter<SUBJECT, ID> getSubjectAndIdConverter() {
        return this.subjectAndIdConverter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public GenericRecord parse(ByteBuffer bytes) {
        Pair<SUBJECT, ID> subjectAndId = this.subjectAndIdConverter.getSubjectAndId(bytes);
        Schema schema = (Schema)this.typedRepository.getSchema(subjectAndId.lhs, subjectAndId.rhs);
        GenericDatumReader reader = new GenericDatumReader(schema);
        try (ByteBufferInputStream inputStream = new ByteBufferInputStream(Collections.singletonList(bytes));){
            GenericRecord genericRecord = (GenericRecord)reader.read(null, (Decoder)DecoderFactory.get().binaryDecoder((InputStream)inputStream, null));
            return genericRecord;
        }
        catch (EOFException eof) {
            throw new ParseException((Throwable)eof, "Avro's unnecessary EOFException, detail: [%s]", new Object[]{"https://issues.apache.org/jira/browse/AVRO-813"});
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e, "Fail to decode avro message!", new Object[0]);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaRepoBasedAvroBytesDecoder that = (SchemaRepoBasedAvroBytesDecoder)o;
        if (!Objects.equals(this.subjectAndIdConverter, that.subjectAndIdConverter)) {
            return false;
        }
        return Objects.equals(this.schemaRepository, that.schemaRepository);
    }

    public int hashCode() {
        int result = this.subjectAndIdConverter != null ? this.subjectAndIdConverter.hashCode() : 0;
        result = 31 * result + (this.schemaRepository != null ? this.schemaRepository.hashCode() : 0);
        return result;
    }
}

