/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.avro;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.druid.data.input.avro.AvroBytesDecoder;
import org.apache.druid.java.util.common.parsers.ParseException;

public class SchemaRegistryBasedAvroBytesDecoder
implements AvroBytesDecoder {
    private final SchemaRegistryClient registry;

    @JsonCreator
    public SchemaRegistryBasedAvroBytesDecoder(@JsonProperty(value="url") String url, @JsonProperty(value="capacity") Integer capacity) {
        int identityMapCapacity = capacity == null ? Integer.MAX_VALUE : capacity;
        this.registry = new CachedSchemaRegistryClient(url, identityMapCapacity);
    }

    @VisibleForTesting
    SchemaRegistryBasedAvroBytesDecoder(SchemaRegistryClient registry) {
        this.registry = registry;
    }

    @Override
    public GenericRecord parse(ByteBuffer bytes) {
        try {
            bytes.get();
            int id = bytes.getInt();
            int length = bytes.limit() - 1 - 4;
            int offset = bytes.position() + bytes.arrayOffset();
            Schema schema = this.registry.getByID(id);
            GenericDatumReader reader = new GenericDatumReader(schema);
            return (GenericRecord)reader.read(null, (Decoder)DecoderFactory.get().binaryDecoder(bytes.array(), offset, length, null));
        }
        catch (Exception e) {
            throw new ParseException((Throwable)e, "Fail to decode avro message!", new Object[0]);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaRegistryBasedAvroBytesDecoder that = (SchemaRegistryBasedAvroBytesDecoder)o;
        return Objects.equals(this.registry, that.registry);
    }

    public int hashCode() {
        return this.registry != null ? this.registry.hashCode() : 0;
    }
}

