/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.avro;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.EOFException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.util.ByteBufferInputStream;
import org.apache.druid.data.input.avro.AvroBytesDecoder;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.ParseException;

public class InlineSchemaAvroBytesDecoder
implements AvroBytesDecoder {
    private static final Logger LOGGER = new Logger(InlineSchemaAvroBytesDecoder.class);
    private final Schema schemaObj;
    private final Map<String, Object> schema;
    private final DatumReader<GenericRecord> reader;

    @JsonCreator
    public InlineSchemaAvroBytesDecoder(@JacksonInject @Json ObjectMapper mapper, @JsonProperty(value="schema") Map<String, Object> schema) throws Exception {
        Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"schema must be provided");
        this.schema = schema;
        String schemaStr = mapper.writeValueAsString(schema);
        LOGGER.debug("Schema string [%s]", new Object[]{schemaStr});
        this.schemaObj = new Schema.Parser().parse(schemaStr);
        this.reader = new GenericDatumReader(this.schemaObj);
    }

    @VisibleForTesting
    InlineSchemaAvroBytesDecoder(Schema schemaObj) {
        this.schemaObj = schemaObj;
        this.reader = new GenericDatumReader(schemaObj);
        this.schema = null;
    }

    @JsonProperty
    public Map<String, Object> getSchema() {
        return this.schema;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public GenericRecord parse(ByteBuffer bytes) {
        try (ByteBufferInputStream inputStream = new ByteBufferInputStream(Collections.singletonList(bytes));){
            GenericRecord genericRecord = (GenericRecord)this.reader.read(null, (Decoder)DecoderFactory.get().binaryDecoder((InputStream)inputStream, null));
            return genericRecord;
        }
        catch (EOFException eof) {
            throw new ParseException((Throwable)eof, "Avro's unnecessary EOFException, detail: [%s]", new Object[]{"https://issues.apache.org/jira/browse/AVRO-813"});
        }
        catch (Exception e) {
            throw new ParseException((Throwable)e, "Fail to decode avro message!", new Object[0]);
        }
    }
}

