/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.avro;

import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.avro.AvroFlattenerMaker;
import org.apache.druid.data.input.avro.AvroParseSpec;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.java.util.common.parsers.ObjectFlattener;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;

public class AvroParsers {
    private AvroParsers() {
    }

    public static ObjectFlattener<GenericRecord> makeFlattener(ParseSpec parseSpec, boolean binaryAsString) {
        JSONPathSpec flattenSpec = parseSpec instanceof AvroParseSpec ? (JSONPathSpec)((AvroParseSpec)parseSpec).getFlattenSpec() : JSONPathSpec.DEFAULT;
        return ObjectFlatteners.create((JSONPathSpec)flattenSpec, (ObjectFlatteners.FlattenerMaker)new AvroFlattenerMaker(binaryAsString));
    }

    public static List<InputRow> parseGenericRecord(GenericRecord record, MapInputRowParser mapParser, ObjectFlattener<GenericRecord> avroFlattener) {
        return mapParser.parseBatch(avroFlattener.flatten((Object)record));
    }
}

