/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.avro;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.druid.data.input.avro.GenericAvroJsonProvider;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.NotImplementedMappingProvider;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;

public class AvroFlattenerMaker
implements ObjectFlatteners.FlattenerMaker<GenericRecord> {
    private static final JsonProvider AVRO_JSON_PROVIDER = new GenericAvroJsonProvider();
    private static final Configuration JSONPATH_CONFIGURATION = Configuration.builder().jsonProvider(AVRO_JSON_PROVIDER).mappingProvider((MappingProvider)new NotImplementedMappingProvider()).options(EnumSet.of(Option.SUPPRESS_EXCEPTIONS)).build();
    private static final EnumSet<Schema.Type> ROOT_TYPES = EnumSet.of(Schema.Type.STRING, new Schema.Type[]{Schema.Type.BYTES, Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE});
    private final boolean binaryAsString;

    private static boolean isPrimitive(Schema schema) {
        return ROOT_TYPES.contains(schema.getType());
    }

    private static boolean isPrimitiveArray(Schema schema) {
        return schema.getType().equals((Object)Schema.Type.ARRAY) && AvroFlattenerMaker.isPrimitive(schema.getElementType());
    }

    private static boolean isOptionalPrimitive(Schema schema) {
        return schema.getType().equals((Object)Schema.Type.UNION) && schema.getTypes().size() == 2 && (((Schema)schema.getTypes().get(0)).getType().equals((Object)Schema.Type.NULL) && (AvroFlattenerMaker.isPrimitive((Schema)schema.getTypes().get(1)) || AvroFlattenerMaker.isPrimitiveArray((Schema)schema.getTypes().get(1))) || ((Schema)schema.getTypes().get(1)).getType().equals((Object)Schema.Type.NULL) && (AvroFlattenerMaker.isPrimitive((Schema)schema.getTypes().get(0)) || AvroFlattenerMaker.isPrimitiveArray((Schema)schema.getTypes().get(0))));
    }

    private static boolean isFieldPrimitive(Schema.Field field) {
        return AvroFlattenerMaker.isPrimitive(field.schema()) || AvroFlattenerMaker.isPrimitiveArray(field.schema()) || AvroFlattenerMaker.isOptionalPrimitive(field.schema());
    }

    public AvroFlattenerMaker(boolean binaryAsString) {
        this.binaryAsString = binaryAsString;
    }

    public Set<String> discoverRootFields(GenericRecord obj) {
        return obj.getSchema().getFields().stream().filter(AvroFlattenerMaker::isFieldPrimitive).map(Schema.Field::name).collect(Collectors.toSet());
    }

    public Object getRootField(GenericRecord record, String key) {
        return this.transformValue(record.get(key));
    }

    public Function<GenericRecord, Object> makeJsonPathExtractor(String expr) {
        JsonPath jsonPath = JsonPath.compile((String)expr, (Predicate[])new Predicate[0]);
        return record -> this.transformValue(jsonPath.read(record, JSONPATH_CONFIGURATION));
    }

    public Function<GenericRecord, Object> makeJsonQueryExtractor(String expr) {
        throw new UnsupportedOperationException("Avro + JQ not supported");
    }

    public JsonProvider getJsonProvider() {
        return AVRO_JSON_PROVIDER;
    }

    private Object transformValue(Object field) {
        if (field instanceof ByteBuffer) {
            if (this.binaryAsString) {
                return StringUtils.fromUtf8((byte[])((ByteBuffer)field).array());
            }
            return ((ByteBuffer)field).array();
        }
        if (field instanceof Utf8) {
            return field.toString();
        }
        if (field instanceof List) {
            return ((List)field).stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        return field;
    }
}

