/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.avro.generic.GenericRecord;
import org.apache.druid.data.input.ByteBufferInputRowParser;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.avro.AvroBytesDecoder;
import org.apache.druid.data.input.avro.AvroParsers;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.java.util.common.parsers.ObjectFlattener;

public class AvroStreamInputRowParser
implements ByteBufferInputRowParser {
    private final ParseSpec parseSpec;
    private final AvroBytesDecoder avroBytesDecoder;
    private final ObjectFlattener<GenericRecord> avroFlattener;
    private final MapInputRowParser mapParser;

    @JsonCreator
    public AvroStreamInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec, @JsonProperty(value="avroBytesDecoder") AvroBytesDecoder avroBytesDecoder) {
        this.parseSpec = (ParseSpec)Preconditions.checkNotNull((Object)parseSpec, (Object)"parseSpec");
        this.avroBytesDecoder = (AvroBytesDecoder)Preconditions.checkNotNull((Object)avroBytesDecoder, (Object)"avroBytesDecoder");
        this.avroFlattener = AvroParsers.makeFlattener(parseSpec, false);
        this.mapParser = new MapInputRowParser(parseSpec);
    }

    public List<InputRow> parseBatch(ByteBuffer input) {
        return AvroParsers.parseGenericRecord(this.avroBytesDecoder.parse(input), this.mapParser, this.avroFlattener);
    }

    @JsonProperty
    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    @JsonProperty
    public AvroBytesDecoder getAvroBytesDecoder() {
        return this.avroBytesDecoder;
    }

    public ByteBufferInputRowParser withParseSpec(ParseSpec parseSpec) {
        return new AvroStreamInputRowParser(parseSpec, this.avroBytesDecoder);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvroStreamInputRowParser that = (AvroStreamInputRowParser)o;
        return Objects.equals(this.parseSpec, that.parseSpec) && Objects.equals(this.avroBytesDecoder, that.avroBytesDecoder);
    }

    public int hashCode() {
        return Objects.hash(this.parseSpec, this.avroBytesDecoder);
    }
}

