/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.avro.AvroParsers;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.java.util.common.parsers.ObjectFlattener;

public class AvroHadoopInputRowParser
implements InputRowParser<GenericRecord> {
    private final ParseSpec parseSpec;
    private final ObjectFlattener<GenericRecord> avroFlattener;
    private final MapInputRowParser mapParser;

    @JsonCreator
    public AvroHadoopInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec) {
        this.parseSpec = parseSpec;
        this.avroFlattener = AvroParsers.makeFlattener(parseSpec, false);
        this.mapParser = new MapInputRowParser(parseSpec);
    }

    public List<InputRow> parseBatch(GenericRecord record) {
        return AvroParsers.parseGenericRecord(record, this.mapParser, this.avroFlattener);
    }

    @JsonProperty
    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    public InputRowParser withParseSpec(ParseSpec parseSpec) {
        return new AvroHadoopInputRowParser(parseSpec);
    }
}

