/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.sql.http.ResultFormat;

public class ArrayWriter
implements ResultFormat.Writer {
    private final JsonGenerator jsonGenerator;
    private final OutputStream outputStream;

    public ArrayWriter(OutputStream outputStream, ObjectMapper jsonMapper) throws IOException {
        this.jsonGenerator = jsonMapper.getFactory().createGenerator(outputStream);
        this.outputStream = outputStream;
    }

    @Override
    public void writeResponseStart() throws IOException {
        this.jsonGenerator.writeStartArray();
    }

    @Override
    public void writeResponseEnd() throws IOException {
        this.jsonGenerator.writeEndArray();
        this.jsonGenerator.flush();
        this.outputStream.write(10);
    }

    @Override
    public void writeHeader(List<String> columnNames) throws IOException {
        this.jsonGenerator.writeStartArray();
        for (String columnName : columnNames) {
            this.jsonGenerator.writeString(columnName);
        }
        this.jsonGenerator.writeEndArray();
    }

    @Override
    public void writeRowStart() throws IOException {
        this.jsonGenerator.writeStartArray();
    }

    @Override
    public void writeRowField(String name, @Nullable Object value) throws IOException {
        this.jsonGenerator.writeObject(value);
    }

    @Override
    public void writeRowEnd() throws IOException {
        this.jsonGenerator.writeEndArray();
    }

    @Override
    public void close() throws IOException {
        this.jsonGenerator.close();
    }
}

