/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.druid.sql.calcite.planner.Calcites;

public class SortCollapseRule
extends RelOptRule {
    private static final SortCollapseRule INSTANCE = new SortCollapseRule();

    public SortCollapseRule() {
        super(SortCollapseRule.operand(Sort.class, (RelOptRuleOperand)SortCollapseRule.operand(Sort.class, (RelOptRuleOperandChildren)SortCollapseRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public static SortCollapseRule instance() {
        return INSTANCE;
    }

    public void onMatch(RelOptRuleCall call) {
        Sort outerSort = (Sort)call.rel(0);
        Sort innerSort = (Sort)call.rel(1);
        if (outerSort.collation.getFieldCollations().isEmpty() || outerSort.collation.getFieldCollations().equals(innerSort.collation.getFieldCollations())) {
            int innerOffset = Calcites.getOffset(innerSort);
            int innerFetch = Calcites.getFetch(innerSort);
            int outerOffset = Calcites.getOffset(outerSort);
            int outerFetch = Calcites.getFetch(outerSort);
            int offset = innerOffset + outerOffset;
            int fetch = Calcites.collapseFetch(innerFetch, outerFetch, outerOffset);
            Sort combined = innerSort.copy(innerSort.getTraitSet(), innerSort.getInput(), innerSort.getCollation(), offset == 0 ? null : call.builder().literal((Object)offset), fetch < 0 ? null : call.builder().literal((Object)fetch));
            call.transformTo((RelNode)combined);
            call.getPlanner().setImportance((RelNode)outerSort, 0.0);
        }
    }
}

