/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.sql.calcite.rel.Projection;

public class Sorting {
    private final List<OrderByColumnSpec> orderBys;
    @Nullable
    private final Projection projection;
    @Nullable
    private final Long limit;

    private Sorting(List<OrderByColumnSpec> orderBys, @Nullable Long limit, @Nullable Projection projection) {
        this.orderBys = (List)Preconditions.checkNotNull(orderBys, (Object)"orderBys");
        this.limit = limit;
        this.projection = projection;
    }

    public static Sorting create(List<OrderByColumnSpec> orderBys, @Nullable Long limit, @Nullable Projection projection) {
        return new Sorting(orderBys, limit, projection);
    }

    public SortKind getSortKind(String timeColumn) {
        OrderByColumnSpec orderBy;
        if (this.orderBys.isEmpty()) {
            return SortKind.UNORDERED;
        }
        if (this.orderBys.size() == 1 && (orderBy = (OrderByColumnSpec)Iterables.getOnlyElement(this.orderBys)).getDimension().equals(timeColumn)) {
            return orderBy.getDirection() == OrderByColumnSpec.Direction.ASCENDING ? SortKind.TIME_ASCENDING : SortKind.TIME_DESCENDING;
        }
        return SortKind.NON_TIME;
    }

    public List<OrderByColumnSpec> getOrderBys() {
        return this.orderBys;
    }

    @Nullable
    public Projection getProjection() {
        return this.projection;
    }

    public boolean isLimited() {
        return this.limit != null;
    }

    @Nullable
    public Long getLimit() {
        return this.limit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sorting sorting = (Sorting)o;
        return Objects.equals(this.orderBys, sorting.orderBys) && Objects.equals(this.projection, sorting.projection) && Objects.equals(this.limit, sorting.limit);
    }

    public int hashCode() {
        return Objects.hash(this.orderBys, this.projection, this.limit);
    }

    public String toString() {
        return "Sorting{orderBys=" + this.orderBys + ", projection=" + this.projection + ", limit=" + this.limit + '}';
    }

    static enum SortKind {
        UNORDERED,
        TIME_ASCENDING,
        TIME_DESCENDING,
        NON_TIME;

    }
}

