/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.DimensionExpression;
import org.apache.druid.sql.calcite.table.RowSignature;

public class Grouping {
    private final List<DimensionExpression> dimensions;
    private final List<Aggregation> aggregations;
    private final DimFilter havingFilter;
    private final RowSignature outputRowSignature;

    private Grouping(List<DimensionExpression> dimensions, List<Aggregation> aggregations, DimFilter havingFilter, RowSignature outputRowSignature) {
        this.dimensions = ImmutableList.copyOf(dimensions);
        this.aggregations = ImmutableList.copyOf(aggregations);
        this.havingFilter = havingFilter;
        this.outputRowSignature = outputRowSignature;
        HashSet<String> seen = new HashSet<String>();
        for (DimensionExpression dimensionExpression : dimensions) {
            if (seen.add(dimensionExpression.getOutputName())) continue;
            throw new ISE("Duplicate field name: %s", new Object[]{dimensionExpression.getOutputName()});
        }
        for (Aggregation aggregation : aggregations) {
            for (AggregatorFactory aggregatorFactory : aggregation.getAggregatorFactories()) {
                if (seen.add(aggregatorFactory.getName())) continue;
                throw new ISE("Duplicate field name: %s", new Object[]{aggregatorFactory.getName()});
            }
            if (aggregation.getPostAggregator() == null || seen.add(aggregation.getPostAggregator().getName())) continue;
            throw new ISE("Duplicate field name: %s", new Object[]{aggregation.getPostAggregator().getName()});
        }
        for (String field : outputRowSignature.getRowOrder()) {
            if (seen.contains(field)) continue;
            throw new ISE("Missing field in rowOrder: %s", new Object[]{field});
        }
    }

    public static Grouping create(List<DimensionExpression> dimensions, List<Aggregation> aggregations, DimFilter havingFilter, RowSignature outputRowSignature) {
        return new Grouping(dimensions, aggregations, havingFilter, outputRowSignature);
    }

    public List<DimensionExpression> getDimensions() {
        return this.dimensions;
    }

    public List<Aggregation> getAggregations() {
        return this.aggregations;
    }

    @Nullable
    public DimFilter getHavingFilter() {
        return this.havingFilter;
    }

    public List<DimensionSpec> getDimensionSpecs() {
        return this.dimensions.stream().map(DimensionExpression::toDimensionSpec).collect(Collectors.toList());
    }

    public List<AggregatorFactory> getAggregatorFactories() {
        return this.aggregations.stream().flatMap(aggregation -> aggregation.getAggregatorFactories().stream()).collect(Collectors.toList());
    }

    public List<PostAggregator> getPostAggregators() {
        return this.aggregations.stream().map(Aggregation::getPostAggregator).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public RowSignature getOutputRowSignature() {
        return this.outputRowSignature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Grouping grouping = (Grouping)o;
        return Objects.equals(this.dimensions, grouping.dimensions) && Objects.equals(this.aggregations, grouping.aggregations) && Objects.equals(this.havingFilter, grouping.havingFilter) && Objects.equals(this.outputRowSignature, grouping.outputRowSignature);
    }

    public int hashCode() {
        return Objects.hash(this.dimensions, this.aggregations, this.havingFilter, this.outputRowSignature);
    }

    public String toString() {
        return "Grouping{dimensions=" + this.dimensions + ", aggregations=" + this.aggregations + ", havingFilter=" + this.havingFilter + ", outputRowSignature=" + this.outputRowSignature + '}';
    }
}

