/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class PlannerContext {
    public static final String CTX_SQL_QUERY_ID = "sqlQueryId";
    public static final String CTX_SQL_CURRENT_TIMESTAMP = "sqlCurrentTimestamp";
    public static final String CTX_SQL_TIME_ZONE = "sqlTimeZone";
    public static final String CTX_SQL_OUTER_LIMIT = "sqlOuterLimit";
    public static final String DATA_CTX_AUTHENTICATION_RESULT = "authenticationResult";
    private final DruidOperatorTable operatorTable;
    private final ExprMacroTable macroTable;
    private final PlannerConfig plannerConfig;
    private final DateTime localNow;
    private final Map<String, Object> queryContext;
    private final AuthenticationResult authenticationResult;
    private final String sqlQueryId;
    private final List<String> nativeQueryIds = new CopyOnWriteArrayList<String>();

    private PlannerContext(DruidOperatorTable operatorTable, ExprMacroTable macroTable, PlannerConfig plannerConfig, DateTime localNow, Map<String, Object> queryContext, AuthenticationResult authenticationResult) {
        this.operatorTable = operatorTable;
        this.macroTable = macroTable;
        this.plannerConfig = (PlannerConfig)Preconditions.checkNotNull((Object)plannerConfig, (Object)"plannerConfig");
        this.queryContext = queryContext != null ? new HashMap<String, Object>(queryContext) : new HashMap();
        this.localNow = (DateTime)Preconditions.checkNotNull((Object)localNow, (Object)"localNow");
        this.authenticationResult = (AuthenticationResult)Preconditions.checkNotNull((Object)authenticationResult, (Object)DATA_CTX_AUTHENTICATION_RESULT);
        String sqlQueryId = (String)this.queryContext.get(CTX_SQL_QUERY_ID);
        if (Strings.isNullOrEmpty((String)sqlQueryId)) {
            sqlQueryId = UUID.randomUUID().toString();
        }
        this.sqlQueryId = sqlQueryId;
    }

    public static PlannerContext create(DruidOperatorTable operatorTable, ExprMacroTable macroTable, PlannerConfig plannerConfig, Map<String, Object> queryContext, AuthenticationResult authenticationResult) {
        DateTimeZone timeZone;
        DateTime utcNow;
        if (queryContext != null) {
            Object tsParam = queryContext.get(CTX_SQL_CURRENT_TIMESTAMP);
            Object tzParam = queryContext.get(CTX_SQL_TIME_ZONE);
            utcNow = tsParam != null ? new DateTime(tsParam, DateTimeZone.UTC) : new DateTime(DateTimeZone.UTC);
            timeZone = tzParam != null ? DateTimes.inferTzFromString((String)String.valueOf(tzParam)) : plannerConfig.getSqlTimeZone();
        } else {
            utcNow = new DateTime(DateTimeZone.UTC);
            timeZone = plannerConfig.getSqlTimeZone();
        }
        return new PlannerContext(operatorTable, macroTable, plannerConfig.withOverrides(queryContext), utcNow.withZone(timeZone), queryContext, authenticationResult);
    }

    public DruidOperatorTable getOperatorTable() {
        return this.operatorTable;
    }

    public ExprMacroTable getExprMacroTable() {
        return this.macroTable;
    }

    public PlannerConfig getPlannerConfig() {
        return this.plannerConfig;
    }

    public DateTime getLocalNow() {
        return this.localNow;
    }

    public DateTimeZone getTimeZone() {
        return this.localNow.getZone();
    }

    public Map<String, Object> getQueryContext() {
        return this.queryContext;
    }

    public AuthenticationResult getAuthenticationResult() {
        return this.authenticationResult;
    }

    public String getSqlQueryId() {
        return this.sqlQueryId;
    }

    public List<String> getNativeQueryIds() {
        return this.nativeQueryIds;
    }

    public void addNativeQueryId(String queryId) {
        this.nativeQueryIds.add(queryId);
    }

    public DataContext createDataContext(final JavaTypeFactory typeFactory) {
        class DruidDataContext
        implements DataContext {
            private final Map<String, Object> context;

            DruidDataContext() {
                this.context = ImmutableMap.of((Object)DataContext.Variable.UTC_TIMESTAMP.camelName, (Object)PlannerContext.this.localNow.getMillis(), (Object)DataContext.Variable.CURRENT_TIMESTAMP.camelName, (Object)PlannerContext.this.localNow.getMillis(), (Object)DataContext.Variable.LOCAL_TIMESTAMP.camelName, (Object)new Interval((ReadableInstant)new DateTime((Object)"1970-01-01T00:00:00.000", PlannerContext.this.localNow.getZone()), (ReadableInstant)PlannerContext.this.localNow).toDurationMillis(), (Object)DataContext.Variable.TIME_ZONE.camelName, (Object)PlannerContext.this.localNow.getZone().toTimeZone().clone(), (Object)PlannerContext.DATA_CTX_AUTHENTICATION_RESULT, (Object)PlannerContext.this.authenticationResult);
            }

            public SchemaPlus getRootSchema() {
                throw new UnsupportedOperationException();
            }

            public JavaTypeFactory getTypeFactory() {
                return typeFactory;
            }

            public QueryProvider getQueryProvider() {
                throw new UnsupportedOperationException();
            }

            public Object get(String name) {
                return this.context.get(name);
            }
        }
        return new DruidDataContext();
    }
}

