/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.filtration;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.sql.calcite.expression.SimpleExtraction;
import org.apache.druid.sql.calcite.filtration.BottomUpTransform;
import org.apache.druid.sql.calcite.filtration.BoundRefKey;
import org.apache.druid.sql.calcite.table.RowSignature;

public class ConvertSelectorsToIns
extends BottomUpTransform {
    private final RowSignature sourceRowSignature;

    private ConvertSelectorsToIns(RowSignature sourceRowSignature) {
        this.sourceRowSignature = sourceRowSignature;
    }

    public static ConvertSelectorsToIns create(RowSignature sourceRowSignature) {
        return new ConvertSelectorsToIns(sourceRowSignature);
    }

    @Override
    public DimFilter process(DimFilter filter) {
        if (filter instanceof OrDimFilter) {
            ArrayList children = Lists.newArrayList((Iterable)((OrDimFilter)filter).getFields());
            HashMap<BoundRefKey, ArrayList<SelectorDimFilter>> selectors = new HashMap<BoundRefKey, ArrayList<SelectorDimFilter>>();
            for (DimFilter dimFilter : children) {
                if (!(dimFilter instanceof SelectorDimFilter)) continue;
                SelectorDimFilter selector = (SelectorDimFilter)dimFilter;
                BoundRefKey boundRefKey = BoundRefKey.from(selector, this.sourceRowSignature.naturalStringComparator(SimpleExtraction.of(selector.getDimension(), selector.getExtractionFn())));
                ArrayList<SelectorDimFilter> filterList = (ArrayList<SelectorDimFilter>)selectors.get(boundRefKey);
                if (filterList == null) {
                    filterList = new ArrayList<SelectorDimFilter>();
                    selectors.put(boundRefKey, filterList);
                }
                filterList.add(selector);
            }
            for (Map.Entry entry : selectors.entrySet()) {
                List filterList = (List)entry.getValue();
                if (filterList.size() <= 1) continue;
                ArrayList<String> values = new ArrayList<String>();
                for (SelectorDimFilter selector : filterList) {
                    values.add(selector.getValue());
                    if (children.remove(selector)) continue;
                    throw new ISE("WTF?! Tried to remove selector but couldn't?", new Object[0]);
                }
                children.add(new InDimFilter(((BoundRefKey)entry.getKey()).getDimension(), values, ((BoundRefKey)entry.getKey()).getExtractionFn(), null));
            }
            if (!children.equals(((OrDimFilter)filter).getFields())) {
                return children.size() == 1 ? (DimFilter)children.get(0) : new OrDimFilter((List)children);
            }
            return filter;
        }
        return filter;
    }
}

