/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.filtration;

import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.ordering.StringComparator;

public class BoundRefKey {
    private final String dimension;
    private final ExtractionFn extractionFn;
    private final StringComparator comparator;

    public BoundRefKey(String dimension, ExtractionFn extractionFn, StringComparator comparator) {
        this.dimension = dimension;
        this.extractionFn = extractionFn;
        this.comparator = comparator;
    }

    public static BoundRefKey from(BoundDimFilter filter) {
        return new BoundRefKey(filter.getDimension(), filter.getExtractionFn(), filter.getOrdering());
    }

    public static BoundRefKey from(SelectorDimFilter filter, StringComparator comparator) {
        return new BoundRefKey(filter.getDimension(), filter.getExtractionFn(), comparator);
    }

    public String getDimension() {
        return this.dimension;
    }

    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    public StringComparator getComparator() {
        return this.comparator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundRefKey boundRefKey = (BoundRefKey)o;
        if (this.dimension != null ? !this.dimension.equals(boundRefKey.dimension) : boundRefKey.dimension != null) {
            return false;
        }
        if (this.extractionFn != null ? !this.extractionFn.equals(boundRefKey.extractionFn) : boundRefKey.extractionFn != null) {
            return false;
        }
        return this.comparator != null ? this.comparator.equals(boundRefKey.comparator) : boundRefKey.comparator == null;
    }

    public int hashCode() {
        int result = this.dimension != null ? this.dimension.hashCode() : 0;
        result = 31 * result + (this.extractionFn != null ? this.extractionFn.hashCode() : 0);
        result = 31 * result + (this.comparator != null ? this.comparator.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BoundRefKey{dimension='" + this.dimension + '\'' + ", extractionFn=" + this.extractionFn + ", comparator=" + this.comparator + '}';
    }
}

