/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import javax.annotation.Nullable;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TimeFloorOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;

public class FloorOperatorConversion
implements SqlOperatorConversion {
    @Override
    public SqlOperator calciteOperator() {
        return SqlStdOperatorTable.FLOOR;
    }

    @Override
    @Nullable
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        RexCall call = (RexCall)rexNode;
        if (call.getOperands().size() == 1) {
            return OperatorConversions.convertCall(plannerContext, rowSignature, (RexNode)call, "floor");
        }
        if (call.getOperands().size() == 2) {
            return DruidExpression.fromFunctionCall("timestamp_floor", TimeFloorOperatorConversion.toTimestampFloorOrCeilArgs(plannerContext, rowSignature, call.getOperands()));
        }
        return null;
    }
}

