/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.first.DoubleFirstAggregatorFactory;
import org.apache.druid.query.aggregation.first.FloatFirstAggregatorFactory;
import org.apache.druid.query.aggregation.first.LongFirstAggregatorFactory;
import org.apache.druid.query.aggregation.first.StringFirstAggregatorFactory;
import org.apache.druid.query.aggregation.last.DoubleLastAggregatorFactory;
import org.apache.druid.query.aggregation.last.FloatLastAggregatorFactory;
import org.apache.druid.query.aggregation.last.LongLastAggregatorFactory;
import org.apache.druid.query.aggregation.last.StringLastAggregatorFactory;
import org.apache.druid.query.aggregation.post.FinalizingFieldAccessPostAggregator;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;
import org.apache.druid.sql.calcite.table.RowSignature;

public class EarliestLatestSqlAggregator
implements SqlAggregator {
    public static final SqlAggregator EARLIEST = new EarliestLatestSqlAggregator(EarliestOrLatest.EARLIEST);
    public static final SqlAggregator LATEST = new EarliestLatestSqlAggregator(EarliestOrLatest.LATEST);
    private final EarliestOrLatest earliestOrLatest;
    private final SqlAggFunction function;

    private EarliestLatestSqlAggregator(EarliestOrLatest earliestOrLatest) {
        this.earliestOrLatest = earliestOrLatest;
        this.function = new EarliestLatestSqlAggFunction(earliestOrLatest);
    }

    @Override
    public SqlAggFunction calciteFunction() {
        return this.function;
    }

    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, String name, AggregateCall aggregateCall, Project project, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        String fieldName;
        String aggregatorName;
        List<RexNode> rexNodes = aggregateCall.getArgList().stream().map(i -> Expressions.fromFieldAccess(rowSignature, project, i)).collect(Collectors.toList());
        List<DruidExpression> args = Expressions.toDruidExpressions(plannerContext, rowSignature, rexNodes);
        if (args == null) {
            return null;
        }
        String string = aggregatorName = finalizeAggregations ? Calcites.makePrefixedName(name, "a") : name;
        if (args.get(0).isDirectColumnAccess()) {
            fieldName = args.get(0).getDirectColumn();
        } else {
            SqlTypeName sqlTypeName = rexNodes.get(0).getType().getSqlTypeName();
            VirtualColumn virtualColumn = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(plannerContext, args.get(0), sqlTypeName);
            fieldName = virtualColumn.getOutputName();
        }
        int maxBytes = rexNodes.size() > 1 ? RexLiteral.intValue((RexNode)rexNodes.get(1)) : -1;
        ValueType outputType = Calcites.getValueTypeForSqlTypeName(aggregateCall.getType().getSqlTypeName());
        if (outputType == null) {
            throw new ISE("Cannot translate output sqlTypeName[%s] to Druid type for aggregator[%s]", new Object[]{aggregateCall.getType().getSqlTypeName(), aggregateCall.getName()});
        }
        return Aggregation.create(Stream.of(virtualColumnRegistry.getVirtualColumn(fieldName)).filter(Objects::nonNull).collect(Collectors.toList()), Collections.singletonList(this.earliestOrLatest.createAggregatorFactory(aggregatorName, fieldName, outputType, maxBytes)), (PostAggregator)(finalizeAggregations ? new FinalizingFieldAccessPostAggregator(name, aggregatorName) : null));
    }

    private static class EarliestLatestSqlAggFunction
    extends SqlAggFunction {
        EarliestLatestSqlAggFunction(EarliestOrLatest earliestOrLatest) {
            super(earliestOrLatest.name(), null, SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0, InferTypes.RETURN_TYPE, OperandTypes.or((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.NUMERIC, OperandTypes.BOOLEAN}), OperandTypes.sequence((String)("'" + earliestOrLatest.name() + "(expr, maxBytesPerString)'\n"), (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.STRING, OperandTypes.and((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.NUMERIC, OperandTypes.LITERAL})})}), SqlFunctionCategory.STRING, false, false);
        }
    }

    static enum EarliestOrLatest {
        EARLIEST{

            @Override
            AggregatorFactory createAggregatorFactory(String name, String fieldName, ValueType type, int maxStringBytes) {
                switch (type) {
                    case LONG: {
                        return new LongFirstAggregatorFactory(name, fieldName);
                    }
                    case FLOAT: {
                        return new FloatFirstAggregatorFactory(name, fieldName);
                    }
                    case DOUBLE: {
                        return new DoubleFirstAggregatorFactory(name, fieldName);
                    }
                    case STRING: {
                        return new StringFirstAggregatorFactory(name, fieldName, Integer.valueOf(maxStringBytes));
                    }
                }
                throw new ISE("Cannot build aggregatorFactory for type[%s]", new Object[]{type});
            }
        }
        ,
        LATEST{

            @Override
            AggregatorFactory createAggregatorFactory(String name, String fieldName, ValueType type, int maxStringBytes) {
                switch (type) {
                    case LONG: {
                        return new LongLastAggregatorFactory(name, fieldName);
                    }
                    case FLOAT: {
                        return new FloatLastAggregatorFactory(name, fieldName);
                    }
                    case DOUBLE: {
                        return new DoubleLastAggregatorFactory(name, fieldName);
                    }
                    case STRING: {
                        return new StringLastAggregatorFactory(name, fieldName, Integer.valueOf(maxStringBytes));
                    }
                }
                throw new ISE("Cannot build aggregatorFactory for type[%s]", new Object[]{type});
            }
        };


        abstract AggregatorFactory createAggregatorFactory(String var1, String var2, ValueType var3, int var4);
    }
}

