/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import io.airlift.airline.Command;
import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.druid.cli.QueryJettyServerInitializer;
import org.apache.druid.cli.ServerRunnable;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.discovery.DataNodeService;
import org.apache.druid.discovery.DruidService;
import org.apache.druid.discovery.LookupNodeService;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.CacheModule;
import org.apache.druid.guice.DruidProcessingModule;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.QueryRunnerFactoryModule;
import org.apache.druid.guice.QueryableModule;
import org.apache.druid.guice.ServerTypeConfig;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.lookup.LookupModule;
import org.apache.druid.server.QueryResource;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.coordination.ServerManager;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordination.ZkCoordinator;
import org.apache.druid.server.http.HistoricalResource;
import org.apache.druid.server.http.SegmentListerResource;
import org.apache.druid.server.http.SelfDiscoveryResource;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.server.metrics.QueryCountStatsProvider;
import org.apache.druid.timeline.PruneLastCompactionState;
import org.eclipse.jetty.server.Server;

@Command(name="historical", description="Runs a Historical node, see https://druid.apache.org/docs/latest/Historical.html for a description")
public class CliHistorical
extends ServerRunnable {
    private static final Logger log = new Logger(CliHistorical.class);

    public CliHistorical() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new DruidProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), binder -> {
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/historical");
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(8083);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(8283);
            binder.bindConstant().annotatedWith(PruneLastCompactionState.class).to(true);
            LifecycleModule.register((Binder)binder, Server.class);
            binder.bind(ServerManager.class).in(LazySingleton.class);
            binder.bind(SegmentManager.class).in(LazySingleton.class);
            binder.bind(ZkCoordinator.class).in(ManageLifecycle.class);
            binder.bind(QuerySegmentWalker.class).to(ServerManager.class).in(LazySingleton.class);
            binder.bind(ServerTypeConfig.class).toInstance((Object)new ServerTypeConfig(ServerType.HISTORICAL));
            binder.bind(JettyServerInitializer.class).to(QueryJettyServerInitializer.class).in(LazySingleton.class);
            binder.bind(QueryCountStatsProvider.class).to(QueryResource.class);
            Jerseys.addResource((Binder)binder, QueryResource.class);
            Jerseys.addResource((Binder)binder, HistoricalResource.class);
            Jerseys.addResource((Binder)binder, SegmentListerResource.class);
            LifecycleModule.register((Binder)binder, QueryResource.class);
            LifecycleModule.register((Binder)binder, ZkCoordinator.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.historical.cache", CacheConfig.class);
            binder.install((Module)new CacheModule());
            CliHistorical.bindNodeRoleAndAnnouncer(binder, ServerRunnable.DiscoverySideEffectsProvider.builder(NodeRole.HISTORICAL).serviceClasses((List<Class<? extends DruidService>>)ImmutableList.of(DataNodeService.class, LookupNodeService.class)).build());
            Jerseys.addResource((Binder)binder, SelfDiscoveryResource.class);
            LifecycleModule.registerKey((Binder)binder, (Key)Key.get(SelfDiscoveryResource.class));
        }, (Object)new LookupModule());
    }
}

