/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.worker.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.hrtr.WorkerHolder;
import org.apache.druid.indexing.worker.WorkerHistoryItem;
import org.apache.druid.indexing.worker.WorkerTaskMonitor;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.coordination.ChangeRequestHistory;
import org.apache.druid.server.coordination.ChangeRequestsSnapshot;
import org.apache.druid.server.http.SegmentListerResource;
import org.apache.druid.server.http.security.StateResourceFilter;

@Path(value="/druid-internal/v1/worker/")
@ResourceFilters(value={StateResourceFilter.class})
public class TaskManagementResource {
    protected static final EmittingLogger log = new EmittingLogger(SegmentListerResource.class);
    protected final ObjectMapper jsonMapper;
    protected final ObjectMapper smileMapper;
    private final WorkerTaskMonitor workerTaskMonitor;

    @Inject
    public TaskManagementResource(@Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, WorkerTaskMonitor workerTaskMonitor) {
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.workerTaskMonitor = workerTaskMonitor;
    }

    @GET
    @Produces(value={"application/json", "application/x-jackson-smile"})
    public Void getWorkerState(@QueryParam(value="counter") long counter, @QueryParam(value="hash") long hash, @QueryParam(value="timeout") long timeout, @Context HttpServletRequest req) throws IOException {
        if (timeout <= 0L) {
            this.sendErrorResponse(req, 400, "timeout must be positive.");
            return null;
        }
        final ResponseContext context = this.createContext(req.getHeader("Accept"));
        final ListenableFuture<ChangeRequestsSnapshot<WorkerHistoryItem>> future = this.workerTaskMonitor.getChangesSince(new ChangeRequestHistory.Counter(counter, hash));
        final AsyncContext asyncContext = req.startAsync();
        asyncContext.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent event) {
            }

            public void onTimeout(AsyncEvent event) {
                future.cancel(true);
                event.getAsyncContext().complete();
            }

            public void onError(AsyncEvent event) {
            }

            public void onStartAsync(AsyncEvent event) {
            }
        });
        Futures.addCallback(future, (FutureCallback)new FutureCallback<ChangeRequestsSnapshot>(){

            public void onSuccess(ChangeRequestsSnapshot result) {
                try {
                    HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                    response.setStatus(200);
                    context.inputMapper.writerWithType(WorkerHolder.WORKER_SYNC_RESP_TYPE_REF).writeValue((OutputStream)asyncContext.getResponse().getOutputStream(), (Object)result);
                    asyncContext.complete();
                }
                catch (Exception ex) {
                    log.debug((Throwable)ex, "Request timed out or closed already.", new Object[0]);
                }
            }

            public void onFailure(Throwable th) {
                try {
                    HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                    if (th instanceof IllegalArgumentException) {
                        response.sendError(400, th.getMessage());
                    } else {
                        response.sendError(500, th.getMessage());
                    }
                    asyncContext.complete();
                }
                catch (Exception ex) {
                    log.debug((Throwable)ex, "Request timed out or closed already.", new Object[0]);
                }
            }
        });
        asyncContext.setTimeout(timeout);
        return null;
    }

    @POST
    @Path(value="/assignTask")
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    public Response assignTask(Task task) {
        try {
            this.workerTaskMonitor.assignTask(task);
            return Response.ok().build();
        }
        catch (RuntimeException ex) {
            return Response.serverError().entity((Object)ex.getMessage()).build();
        }
    }

    private void sendErrorResponse(HttpServletRequest req, int code, String error) throws IOException {
        AsyncContext asyncContext = req.startAsync();
        HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
        response.sendError(code, error);
        asyncContext.complete();
    }

    private ResponseContext createContext(String requestType) {
        boolean isSmile = "application/x-jackson-smile".equals(requestType);
        return new ResponseContext(isSmile ? this.smileMapper : this.jsonMapper);
    }

    private static class ResponseContext {
        private final ObjectMapper inputMapper;

        ResponseContext(ObjectMapper inputMapper) {
            this.inputMapper = inputMapper;
        }
    }
}

