/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.sampler;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SamplerResponse {
    private final int numRowsRead;
    private final int numRowsIndexed;
    private final List<SamplerResponseRow> data;

    public SamplerResponse(int numRowsRead, int numRowsIndexed, List<SamplerResponseRow> data) {
        this.numRowsRead = numRowsRead;
        this.numRowsIndexed = numRowsIndexed;
        this.data = data;
    }

    @JsonProperty
    public int getNumRowsRead() {
        return this.numRowsRead;
    }

    @JsonProperty
    public int getNumRowsIndexed() {
        return this.numRowsIndexed;
    }

    @JsonProperty
    public List<SamplerResponseRow> getData() {
        return this.data;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class SamplerResponseRow {
        private final Map<String, Object> input;
        private final Map<String, Object> parsed;
        private final Boolean unparseable;
        private final String error;

        public SamplerResponseRow(Map<String, Object> input, Map<String, Object> parsed, Boolean unparseable, String error) {
            this.input = input;
            this.parsed = parsed;
            this.unparseable = unparseable;
            this.error = error;
        }

        @JsonProperty
        public Map<String, Object> getInput() {
            return this.input;
        }

        @JsonProperty
        public Map<String, Object> getParsed() {
            return this.parsed;
        }

        @JsonProperty
        public Boolean isUnparseable() {
            return this.unparseable;
        }

        @JsonProperty
        public String getError() {
            return this.error;
        }

        public SamplerResponseRow withParsed(Map<String, Object> parsed) {
            return new SamplerResponseRow(this.input, parsed, this.unparseable, this.error);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SamplerResponseRow that = (SamplerResponseRow)o;
            return Objects.equals(this.input, that.input) && Objects.equals(this.parsed, that.parsed) && Objects.equals(this.unparseable, that.unparseable) && Objects.equals(this.error, that.error);
        }

        public int hashCode() {
            return Objects.hash(this.input, this.parsed, this.unparseable, this.error);
        }

        public String toString() {
            return "SamplerResponseRow{rawInput=" + this.input + ", parsed=" + this.parsed + ", unparseable=" + this.unparseable + ", error='" + this.error + '\'' + '}';
        }
    }
}

