/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.sampler;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.data.input.FirehoseFactoryToInputSourceAdaptor;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.indexing.common.task.IndexTask;
import org.apache.druid.indexing.overlord.sampler.InputSourceSampler;
import org.apache.druid.indexing.overlord.sampler.SamplerConfig;
import org.apache.druid.indexing.overlord.sampler.SamplerResponse;
import org.apache.druid.indexing.overlord.sampler.SamplerSpec;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.indexing.DataSchema;

public class IndexTaskSamplerSpec
implements SamplerSpec {
    @Nullable
    private final DataSchema dataSchema;
    private final InputSource inputSource;
    @Nullable
    private final InputFormat inputFormat;
    @Nullable
    private final SamplerConfig samplerConfig;
    private final InputSourceSampler inputSourceSampler;

    @JsonCreator
    public IndexTaskSamplerSpec(@JsonProperty(value="spec") IndexTask.IndexIngestionSpec ingestionSpec, @JsonProperty(value="samplerConfig") @Nullable SamplerConfig samplerConfig, @JacksonInject InputSourceSampler inputSourceSampler) {
        this.dataSchema = ((IndexTask.IndexIngestionSpec)((Object)Preconditions.checkNotNull((Object)((Object)ingestionSpec), (Object)"[spec] is required"))).getDataSchema();
        Preconditions.checkNotNull((Object)ingestionSpec.getIOConfig(), (Object)"[spec.ioConfig] is required");
        if (ingestionSpec.getIOConfig().getInputSource() != null) {
            this.inputSource = ingestionSpec.getIOConfig().getInputSource();
            this.inputFormat = ingestionSpec.getIOConfig().getInputSource().needsFormat() ? (InputFormat)Preconditions.checkNotNull((Object)ingestionSpec.getIOConfig().getInputFormat(), (Object)"[spec.ioConfig.inputFormat] is required") : null;
        } else {
            FirehoseFactory firehoseFactory = (FirehoseFactory)Preconditions.checkNotNull((Object)ingestionSpec.getIOConfig().getFirehoseFactory(), (Object)"[spec.ioConfig.firehose] is required");
            if (!(firehoseFactory instanceof FiniteFirehoseFactory)) {
                throw new IAE("firehose should be an instance of FiniteFirehoseFactory", new Object[0]);
            }
            this.inputSource = new FirehoseFactoryToInputSourceAdaptor((FiniteFirehoseFactory)firehoseFactory, ingestionSpec.getDataSchema().getParser());
            this.inputFormat = null;
        }
        this.samplerConfig = samplerConfig;
        this.inputSourceSampler = inputSourceSampler;
    }

    @Override
    public SamplerResponse sample() {
        return this.inputSourceSampler.sample(this.inputSource, this.inputFormat, this.dataSchema, this.samplerConfig);
    }
}

