/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.ByteSource;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.indexer.RunnerTaskState;
import org.apache.druid.indexer.TaskInfo;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionHolder;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageAdapter;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.TaskQueue;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerWorkItem;
import org.apache.druid.indexing.overlord.TaskStorageQueryAdapter;
import org.apache.druid.indexing.overlord.WorkerTaskRunner;
import org.apache.druid.indexing.overlord.WorkerTaskRunnerQueryAdapter;
import org.apache.druid.indexing.overlord.autoscaling.ScalingStats;
import org.apache.druid.indexing.overlord.http.TaskPayloadResponse;
import org.apache.druid.indexing.overlord.http.TaskStatusResponse;
import org.apache.druid.indexing.overlord.http.security.TaskResourceFilter;
import org.apache.druid.indexing.overlord.setup.WorkerBehaviorConfig;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.EntryExistsException;
import org.apache.druid.server.http.security.ConfigResourceFilter;
import org.apache.druid.server.http.security.DatasourceResourceFilter;
import org.apache.druid.server.http.security.StateResourceFilter;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.server.security.ResourceType;
import org.apache.druid.tasklogs.TaskLogStreamer;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;

@Path(value="/druid/indexer/v1")
public class OverlordResource {
    private static final Logger log = new Logger(OverlordResource.class);
    private final TaskMaster taskMaster;
    private final TaskStorageQueryAdapter taskStorageQueryAdapter;
    private final IndexerMetadataStorageAdapter indexerMetadataStorageAdapter;
    private final TaskLogStreamer taskLogStreamer;
    private final JacksonConfigManager configManager;
    private final AuditManager auditManager;
    private final AuthorizerMapper authorizerMapper;
    private final WorkerTaskRunnerQueryAdapter workerTaskRunnerQueryAdapter;
    private AtomicReference<WorkerBehaviorConfig> workerConfigRef = null;
    private static final List API_TASK_STATES = ImmutableList.of((Object)"pending", (Object)"waiting", (Object)"running", (Object)"complete");

    @Inject
    public OverlordResource(TaskMaster taskMaster, TaskStorageQueryAdapter taskStorageQueryAdapter, IndexerMetadataStorageAdapter indexerMetadataStorageAdapter, TaskLogStreamer taskLogStreamer, JacksonConfigManager configManager, AuditManager auditManager, AuthorizerMapper authorizerMapper, WorkerTaskRunnerQueryAdapter workerTaskRunnerQueryAdapter) {
        this.taskMaster = taskMaster;
        this.taskStorageQueryAdapter = taskStorageQueryAdapter;
        this.indexerMetadataStorageAdapter = indexerMetadataStorageAdapter;
        this.taskLogStreamer = taskLogStreamer;
        this.configManager = configManager;
        this.auditManager = auditManager;
        this.authorizerMapper = authorizerMapper;
        this.workerTaskRunnerQueryAdapter = workerTaskRunnerQueryAdapter;
    }

    @POST
    @Path(value="/task")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response taskPost(final Task task, @Context HttpServletRequest req) {
        String dataSource = task.getDataSource();
        ResourceAction resourceAction = new ResourceAction(new Resource(dataSource, ResourceType.DATASOURCE), Action.WRITE);
        Access authResult = AuthorizationUtils.authorizeResourceAction((HttpServletRequest)req, (ResourceAction)resourceAction, (AuthorizerMapper)this.authorizerMapper);
        if (!authResult.isAllowed()) {
            throw new ForbiddenException(authResult.getMessage());
        }
        return this.asLeaderWith(this.taskMaster.getTaskQueue(), new Function<TaskQueue, Response>(){

            public Response apply(TaskQueue taskQueue) {
                try {
                    taskQueue.add(task);
                    return Response.ok((Object)ImmutableMap.of((Object)"task", (Object)task.getId())).build();
                }
                catch (EntryExistsException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)"Task[%s] already exists!", (Object[])new Object[]{task.getId()}))).build();
                }
            }
        });
    }

    @GET
    @Path(value="/leader")
    @ResourceFilters(value={StateResourceFilter.class})
    @Produces(value={"application/json"})
    public Response getLeader() {
        return Response.ok((Object)this.taskMaster.getCurrentLeader()).build();
    }

    @GET
    @Path(value="/isLeader")
    @Produces(value={"application/json"})
    public Response isLeader() {
        boolean leading = this.taskMaster.isLeader();
        ImmutableMap response = ImmutableMap.of((Object)"leader", (Object)leading);
        if (leading) {
            return Response.ok((Object)response).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)response).build();
    }

    @GET
    @Path(value="/task/{taskid}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={TaskResourceFilter.class})
    public Response getTaskPayload(@PathParam(value="taskid") String taskid) {
        TaskPayloadResponse response = new TaskPayloadResponse(taskid, (Task)this.taskStorageQueryAdapter.getTask(taskid).orNull());
        Response.Status status = response.getPayload() == null ? Response.Status.NOT_FOUND : Response.Status.OK;
        return Response.status((Response.Status)status).entity((Object)response).build();
    }

    @GET
    @Path(value="/task/{taskid}/status")
    @Produces(value={"application/json"})
    @ResourceFilters(value={TaskResourceFilter.class})
    public Response getTaskStatus(@PathParam(value="taskid") String taskid) {
        TaskInfo<Task, TaskStatus> taskInfo = this.taskStorageQueryAdapter.getTaskInfo(taskid);
        TaskStatusResponse response = null;
        if (taskInfo != null) {
            TaskRunner taskRunner;
            TaskRunnerWorkItem workItem;
            if (this.taskMaster.getTaskRunner().isPresent() && (workItem = (TaskRunnerWorkItem)(taskRunner = (TaskRunner)this.taskMaster.getTaskRunner().get()).getKnownTasks().stream().filter(item -> item.getTaskId().equals(taskid)).findAny().orElse(null)) != null) {
                response = new TaskStatusResponse(workItem.getTaskId(), new TaskStatusPlus(taskInfo.getId(), taskInfo.getTask() == null ? null : ((Task)taskInfo.getTask()).getGroupId(), taskInfo.getTask() == null ? null : ((Task)taskInfo.getTask()).getType(), taskInfo.getCreatedTime(), DateTimes.EPOCH, ((TaskStatus)taskInfo.getStatus()).getStatusCode(), taskRunner.getRunnerTaskState(workItem.getTaskId()), Long.valueOf(((TaskStatus)taskInfo.getStatus()).getDuration()), workItem.getLocation(), taskInfo.getDataSource(), ((TaskStatus)taskInfo.getStatus()).getErrorMsg()));
            }
            if (response == null) {
                response = new TaskStatusResponse(taskid, new TaskStatusPlus(taskInfo.getId(), taskInfo.getTask() == null ? null : ((Task)taskInfo.getTask()).getGroupId(), taskInfo.getTask() == null ? null : ((Task)taskInfo.getTask()).getType(), taskInfo.getCreatedTime(), DateTimes.EPOCH, ((TaskStatus)taskInfo.getStatus()).getStatusCode(), RunnerTaskState.WAITING, Long.valueOf(((TaskStatus)taskInfo.getStatus()).getDuration()), ((TaskStatus)taskInfo.getStatus()).getLocation() == null ? TaskLocation.unknown() : ((TaskStatus)taskInfo.getStatus()).getLocation(), taskInfo.getDataSource(), ((TaskStatus)taskInfo.getStatus()).getErrorMsg()));
            }
        } else {
            response = new TaskStatusResponse(taskid, null);
        }
        Response.Status status = response.getStatus() == null ? Response.Status.NOT_FOUND : Response.Status.OK;
        return Response.status((Response.Status)status).entity((Object)response).build();
    }

    @Deprecated
    @GET
    @Path(value="/task/{taskid}/segments")
    @Produces(value={"application/json"})
    @ResourceFilters(value={TaskResourceFilter.class})
    public Response getTaskSegments(@PathParam(value="taskid") String taskid) {
        Set<DataSegment> segments = this.taskStorageQueryAdapter.getInsertedSegments(taskid);
        return Response.ok().entity(segments).build();
    }

    @POST
    @Path(value="/task/{taskid}/shutdown")
    @Produces(value={"application/json"})
    @ResourceFilters(value={TaskResourceFilter.class})
    public Response doShutdown(final @PathParam(value="taskid") String taskid) {
        return this.asLeaderWith(this.taskMaster.getTaskQueue(), new Function<TaskQueue, Response>(){

            public Response apply(TaskQueue taskQueue) {
                taskQueue.shutdown(taskid, "Shutdown request from user", new Object[0]);
                return Response.ok((Object)ImmutableMap.of((Object)"task", (Object)taskid)).build();
            }
        });
    }

    @POST
    @Path(value="/datasources/{dataSource}/shutdownAllTasks")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response shutdownTasksForDataSource(final @PathParam(value="dataSource") String dataSource) {
        return this.asLeaderWith(this.taskMaster.getTaskQueue(), new Function<TaskQueue, Response>(){

            public Response apply(TaskQueue taskQueue) {
                List<TaskInfo<Task, TaskStatus>> tasks = OverlordResource.this.taskStorageQueryAdapter.getActiveTaskInfo(dataSource);
                if (tasks.isEmpty()) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                for (TaskInfo<Task, TaskStatus> task : tasks) {
                    taskQueue.shutdown(task.getId(), "Shutdown request from user", new Object[0]);
                }
                return Response.ok((Object)ImmutableMap.of((Object)"dataSource", (Object)dataSource)).build();
            }
        });
    }

    @POST
    @Path(value="/taskStatus")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response getMultipleTaskStatuses(Set<String> taskIds) {
        if (taskIds == null || taskIds.size() == 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No TaskIds provided.").build();
        }
        HashMap<String, Object> result = new HashMap<String, Object>(taskIds.size());
        for (String taskId : taskIds) {
            Optional<TaskStatus> optional = this.taskStorageQueryAdapter.getStatus(taskId);
            if (!optional.isPresent()) continue;
            result.put(taskId, optional.get());
        }
        return Response.ok().entity(result).build();
    }

    @GET
    @Path(value="/worker")
    @Produces(value={"application/json"})
    @ResourceFilters(value={ConfigResourceFilter.class})
    public Response getWorkerConfig() {
        if (this.workerConfigRef == null) {
            this.workerConfigRef = this.configManager.watch("worker.config", WorkerBehaviorConfig.class);
        }
        return Response.ok((Object)this.workerConfigRef.get()).build();
    }

    @POST
    @Path(value="/worker")
    @Consumes(value={"application/json"})
    @ResourceFilters(value={ConfigResourceFilter.class})
    public Response setWorkerConfig(WorkerBehaviorConfig workerBehaviorConfig, @HeaderParam(value="X-Druid-Author") @DefaultValue(value="") String author, @HeaderParam(value="X-Druid-Comment") @DefaultValue(value="") String comment, @Context HttpServletRequest req) {
        ConfigManager.SetResult setResult = this.configManager.set("worker.config", (Object)workerBehaviorConfig, new AuditInfo(author, comment, req.getRemoteAddr()));
        if (setResult.isOk()) {
            log.info("Updating Worker configs: %s", new Object[]{workerBehaviorConfig});
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @GET
    @Path(value="/worker/history")
    @Produces(value={"application/json"})
    @ResourceFilters(value={ConfigResourceFilter.class})
    public Response getWorkerConfigHistory(@QueryParam(value="interval") String interval, @QueryParam(value="count") Integer count) {
        Interval theInterval;
        Interval interval2 = theInterval = interval == null ? null : Intervals.of((String)interval);
        if (theInterval == null && count != null) {
            try {
                List workerEntryList = this.auditManager.fetchAuditHistory("worker.config", "worker.config", count.intValue());
                return Response.ok((Object)workerEntryList).build();
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)e.getMessage())).build();
            }
        }
        List workerEntryList = this.auditManager.fetchAuditHistory("worker.config", "worker.config", theInterval);
        return Response.ok((Object)workerEntryList).build();
    }

    @POST
    @Path(value="/action")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response doAction(final TaskActionHolder holder) {
        return this.asLeaderWith(this.taskMaster.getTaskActionClient(holder.getTask()), new Function<TaskActionClient, Response>(){

            public Response apply(TaskActionClient taskActionClient) {
                HashMap retMap;
                try {
                    Object ret = taskActionClient.submit(holder.getAction());
                    retMap = new HashMap();
                    retMap.put("result", ret);
                }
                catch (Exception e) {
                    log.warn((Throwable)e, "Failed to perform task action", new Object[0]);
                    return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)e.getMessage())).build();
                }
                return Response.ok().entity(retMap).build();
            }
        });
    }

    @GET
    @Path(value="/waitingTasks")
    @Produces(value={"application/json"})
    public Response getWaitingTasks(@Context HttpServletRequest req) {
        return this.getTasks("waiting", null, null, null, null, req);
    }

    @GET
    @Path(value="/pendingTasks")
    @Produces(value={"application/json"})
    public Response getPendingTasks(@Context HttpServletRequest req) {
        return this.getTasks("pending", null, null, null, null, req);
    }

    @GET
    @Path(value="/runningTasks")
    @Produces(value={"application/json"})
    public Response getRunningTasks(@QueryParam(value="type") String taskType, @Context HttpServletRequest req) {
        return this.getTasks("running", null, null, null, taskType, req);
    }

    @GET
    @Path(value="/completeTasks")
    @Produces(value={"application/json"})
    public Response getCompleteTasks(@QueryParam(value="n") Integer maxTaskStatuses, @Context HttpServletRequest req) {
        return this.getTasks("complete", null, null, maxTaskStatuses, null, req);
    }

    @GET
    @Path(value="/tasks")
    @Produces(value={"application/json"})
    public Response getTasks(@QueryParam(value="state") String state, @QueryParam(value="datasource") String dataSource, @QueryParam(value="createdTimeInterval") String createdTimeInterval, @QueryParam(value="max") Integer maxCompletedTasks, @QueryParam(value="type") String type, @Context HttpServletRequest req) {
        ResourceAction resourceAction;
        Access authResult;
        if (state != null && !API_TASK_STATES.contains(StringUtils.toLowerCase((String)state))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)StringUtils.format((String)"Invalid state : %s, valid values are: %s", (Object[])new Object[]{state, API_TASK_STATES})).build();
        }
        if (dataSource != null && !(authResult = AuthorizationUtils.authorizeResourceAction((HttpServletRequest)req, (ResourceAction)(resourceAction = new ResourceAction(new Resource(dataSource, ResourceType.DATASOURCE), Action.READ)), (AuthorizerMapper)this.authorizerMapper)).isAllowed()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)StringUtils.format((String)"Access-Check-Result: %s", (Object[])new Object[]{authResult.toString()})).build());
        }
        ArrayList<TaskStatusPlus> finalTaskList = new ArrayList<TaskStatusPlus>();
        Function activeTaskTransformFunc = workItem -> new TaskStatusPlus(workItem.getTaskId(), workItem.getTaskGroupId(), workItem.getTaskType(), workItem.getCreatedTime(), workItem.getQueueInsertionTime(), workItem.getTaskState(), workItem.getRunnerTaskState(), null, workItem.getLocation(), workItem.getDataSource(), null);
        Function completeTaskTransformFunc = taskInfo -> new TaskStatusPlus(taskInfo.getId(), taskInfo.getTask() == null ? null : ((Task)taskInfo.getTask()).getGroupId(), taskInfo.getTask() == null ? null : ((Task)taskInfo.getTask()).getType(), taskInfo.getCreatedTime(), DateTimes.EPOCH, ((TaskStatus)taskInfo.getStatus()).getStatusCode(), RunnerTaskState.NONE, Long.valueOf(((TaskStatus)taskInfo.getStatus()).getDuration()), ((TaskStatus)taskInfo.getStatus()).getLocation() == null ? TaskLocation.unknown() : ((TaskStatus)taskInfo.getStatus()).getLocation(), taskInfo.getDataSource(), ((TaskStatus)taskInfo.getStatus()).getErrorMsg());
        if (state == null || "complete".equals(StringUtils.toLowerCase((String)state))) {
            Duration createdTimeDuration = null;
            if (createdTimeInterval != null) {
                Interval theInterval = Intervals.of((String)StringUtils.replace((String)createdTimeInterval, (String)"_", (String)"/"));
                createdTimeDuration = theInterval.toDuration();
            }
            List<TaskInfo<Task, TaskStatus>> taskInfoList = this.taskStorageQueryAdapter.getCompletedTaskInfoByCreatedTimeDuration(maxCompletedTasks, createdTimeDuration, dataSource);
            List completedTasks = taskInfoList.stream().map(arg_0 -> ((Function)completeTaskTransformFunc).apply(arg_0)).collect(Collectors.toList());
            finalTaskList.addAll(completedTasks);
        }
        ArrayList<AnyTask> allActiveTasks = new ArrayList<AnyTask>();
        if (state == null || !"complete".equals(StringUtils.toLowerCase((String)state))) {
            List<TaskInfo<Task, TaskStatus>> allActiveTaskInfo = this.taskStorageQueryAdapter.getActiveTaskInfo(dataSource);
            for (TaskInfo<Task, TaskStatus> task : allActiveTaskInfo) {
                allActiveTasks.add(new AnyTask(task.getId(), task.getTask() == null ? null : ((Task)task.getTask()).getGroupId(), task.getTask() == null ? null : ((Task)task.getTask()).getType(), (ListenableFuture<TaskStatus>)SettableFuture.create(), task.getDataSource(), null, null, task.getCreatedTime(), DateTimes.EPOCH, TaskLocation.unknown()));
            }
        }
        if (state == null || "waiting".equals(StringUtils.toLowerCase((String)state))) {
            List<AnyTask> waitingWorkItems = this.filterActiveTasks(RunnerTaskState.WAITING, allActiveTasks);
            List transformedWaitingList = waitingWorkItems.stream().map(arg_0 -> ((Function)activeTaskTransformFunc).apply(arg_0)).collect(Collectors.toList());
            finalTaskList.addAll(transformedWaitingList);
        }
        if (state == null || "pending".equals(StringUtils.toLowerCase((String)state))) {
            List<AnyTask> pendingWorkItems = this.filterActiveTasks(RunnerTaskState.PENDING, allActiveTasks);
            List transformedPendingList = pendingWorkItems.stream().map(arg_0 -> ((Function)activeTaskTransformFunc).apply(arg_0)).collect(Collectors.toList());
            finalTaskList.addAll(transformedPendingList);
        }
        if (state == null || "running".equals(StringUtils.toLowerCase((String)state))) {
            List<AnyTask> runningWorkItems = this.filterActiveTasks(RunnerTaskState.RUNNING, allActiveTasks);
            List transformedRunningList = runningWorkItems.stream().map(arg_0 -> ((Function)activeTaskTransformFunc).apply(arg_0)).collect(Collectors.toList());
            finalTaskList.addAll(transformedRunningList);
        }
        List<TaskStatusPlus> authorizedList = this.securedTaskStatusPlus(finalTaskList, dataSource, type, req);
        return Response.ok(authorizedList).build();
    }

    @DELETE
    @Path(value="/pendingSegments/{dataSource}")
    @Produces(value={"application/json"})
    public Response killPendingSegments(@PathParam(value="dataSource") String dataSource, @QueryParam(value="interval") String deleteIntervalString, @Context HttpServletRequest request) {
        Interval deleteInterval = Intervals.of((String)deleteIntervalString);
        Access authResult = AuthorizationUtils.authorizeAllResourceActions((HttpServletRequest)request, (Iterable)ImmutableList.of((Object)new ResourceAction(new Resource(dataSource, ResourceType.DATASOURCE), Action.READ), (Object)new ResourceAction(new Resource(dataSource, ResourceType.DATASOURCE), Action.WRITE)), (AuthorizerMapper)this.authorizerMapper);
        if (!authResult.isAllowed()) {
            throw new ForbiddenException(authResult.getMessage());
        }
        if (this.taskMaster.isLeader()) {
            int numDeleted = this.indexerMetadataStorageAdapter.deletePendingSegments(dataSource, deleteInterval);
            return Response.ok().entity((Object)ImmutableMap.of((Object)"numDeleted", (Object)numDeleted)).build();
        }
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
    }

    @GET
    @Path(value="/workers")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response getWorkers() {
        return this.asLeaderWith(this.taskMaster.getTaskRunner(), new Function<TaskRunner, Response>(){

            public Response apply(TaskRunner taskRunner) {
                if (taskRunner instanceof WorkerTaskRunner) {
                    return Response.ok(((WorkerTaskRunner)taskRunner).getWorkers()).build();
                }
                log.debug("Task runner [%s] of type [%s] does not support listing workers", new Object[]{taskRunner, taskRunner.getClass().getName()});
                return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)"Task Runner does not support worker listing")).build();
            }
        });
    }

    @POST
    @Path(value="/worker/{host}/enable")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response enableWorker(@PathParam(value="host") String host) {
        return this.changeWorkerStatus(host, WorkerTaskRunner.ActionType.ENABLE);
    }

    @POST
    @Path(value="/worker/{host}/disable")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response disableWorker(@PathParam(value="host") String host) {
        return this.changeWorkerStatus(host, WorkerTaskRunner.ActionType.DISABLE);
    }

    private Response changeWorkerStatus(String host, WorkerTaskRunner.ActionType action) {
        try {
            if (WorkerTaskRunner.ActionType.DISABLE.equals((Object)action)) {
                this.workerTaskRunnerQueryAdapter.disableWorker(host);
                return Response.ok((Object)ImmutableMap.of((Object)host, (Object)"disabled")).build();
            }
            if (WorkerTaskRunner.ActionType.ENABLE.equals((Object)action)) {
                this.workerTaskRunnerQueryAdapter.enableWorker(host);
                return Response.ok((Object)ImmutableMap.of((Object)host, (Object)"enabled")).build();
            }
            return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)("Worker does not support " + (Object)((Object)action) + " action!"))).build();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error in posting [%s] action to [%s]", new Object[]{action, host});
            return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)e.getMessage())).build();
        }
    }

    @GET
    @Path(value="/scaling")
    @Produces(value={"application/json"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response getScalingState() {
        Optional<ScalingStats> rms = this.taskMaster.getScalingStats();
        if (rms.isPresent()) {
            return Response.ok((Object)rms.get()).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/task/{taskid}/log")
    @Produces(value={"text/plain; charset=UTF-8"})
    @ResourceFilters(value={TaskResourceFilter.class})
    public Response doGetLog(@PathParam(value="taskid") String taskid, @QueryParam(value="offset") @DefaultValue(value="0") long offset) {
        try {
            Optional stream = this.taskLogStreamer.streamTaskLog(taskid, offset);
            if (stream.isPresent()) {
                return Response.ok((Object)((ByteSource)stream.get()).openStream()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No log was found for this task. The task may not exist, or it may not have begun running yet.").build();
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to stream log for task %s", new Object[]{taskid});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/task/{taskid}/reports")
    @Produces(value={"application/json"})
    @ResourceFilters(value={TaskResourceFilter.class})
    public Response doGetReports(@PathParam(value="taskid") String taskid) {
        try {
            Optional stream = this.taskLogStreamer.streamTaskReports(taskid);
            if (stream.isPresent()) {
                return Response.ok((Object)((ByteSource)stream.get()).openStream()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No task reports were found for this task. The task may not exist, or it may not have completed yet.").build();
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to stream task reports for task %s", new Object[]{taskid});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private <T> Response asLeaderWith(Optional<T> x, Function<T, Response> f) {
        if (x.isPresent()) {
            return (Response)f.apply(x.get());
        }
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
    }

    private List<AnyTask> filterActiveTasks(RunnerTaskState state, List<AnyTask> allTasks) {
        Optional<TaskRunner> taskRunnerOpt = this.taskMaster.getTaskRunner();
        if (!taskRunnerOpt.isPresent()) {
            throw new WebApplicationException(Response.serverError().entity((Object)"No task runner found").build());
        }
        TaskRunner runner = (TaskRunner)taskRunnerOpt.get();
        if (RunnerTaskState.WAITING.equals((Object)state)) {
            Collection<? extends TaskRunnerWorkItem> runnersKnownTasks = runner.getKnownTasks();
            Set runnerKnownTaskIds = runnersKnownTasks.stream().map(TaskRunnerWorkItem::getTaskId).collect(Collectors.toSet());
            ArrayList<AnyTask> waitingTasks = new ArrayList<AnyTask>();
            for (TaskRunnerWorkItem taskRunnerWorkItem : allTasks) {
                if (runnerKnownTaskIds.contains(taskRunnerWorkItem.getTaskId())) continue;
                waitingTasks.add(((AnyTask)taskRunnerWorkItem).withTaskState(TaskState.RUNNING, RunnerTaskState.WAITING, taskRunnerWorkItem.getCreatedTime(), taskRunnerWorkItem.getQueueInsertionTime(), taskRunnerWorkItem.getLocation()));
            }
            return waitingTasks;
        }
        if (RunnerTaskState.PENDING.equals((Object)state)) {
            Collection<? extends TaskRunnerWorkItem> knownPendingTasks = runner.getPendingTasks();
            Set pendingTaskIds = knownPendingTasks.stream().map(TaskRunnerWorkItem::getTaskId).collect(Collectors.toSet());
            Map workItemIdMap = knownPendingTasks.stream().collect(Collectors.toMap(TaskRunnerWorkItem::getTaskId, java.util.function.Function.identity(), (previousWorkItem, newWorkItem) -> newWorkItem));
            ArrayList<AnyTask> pendingTasks = new ArrayList<AnyTask>();
            for (TaskRunnerWorkItem taskRunnerWorkItem : allTasks) {
                if (!pendingTaskIds.contains(taskRunnerWorkItem.getTaskId())) continue;
                pendingTasks.add(((AnyTask)taskRunnerWorkItem).withTaskState(TaskState.RUNNING, RunnerTaskState.PENDING, ((TaskRunnerWorkItem)workItemIdMap.get(taskRunnerWorkItem.getTaskId())).getCreatedTime(), ((TaskRunnerWorkItem)workItemIdMap.get(taskRunnerWorkItem.getTaskId())).getQueueInsertionTime(), ((TaskRunnerWorkItem)workItemIdMap.get(taskRunnerWorkItem.getTaskId())).getLocation()));
            }
            return pendingTasks;
        }
        if (RunnerTaskState.RUNNING.equals((Object)state)) {
            Collection<? extends TaskRunnerWorkItem> knownRunningTasks = runner.getRunningTasks();
            Set runningTaskIds = knownRunningTasks.stream().map(TaskRunnerWorkItem::getTaskId).collect(Collectors.toSet());
            Map workItemIdMap = knownRunningTasks.stream().collect(Collectors.toMap(TaskRunnerWorkItem::getTaskId, java.util.function.Function.identity(), (previousWorkItem, newWorkItem) -> newWorkItem));
            ArrayList<AnyTask> runningTasks = new ArrayList<AnyTask>();
            for (TaskRunnerWorkItem taskRunnerWorkItem : allTasks) {
                if (!runningTaskIds.contains(taskRunnerWorkItem.getTaskId())) continue;
                runningTasks.add(((AnyTask)taskRunnerWorkItem).withTaskState(TaskState.RUNNING, RunnerTaskState.RUNNING, ((TaskRunnerWorkItem)workItemIdMap.get(taskRunnerWorkItem.getTaskId())).getCreatedTime(), ((TaskRunnerWorkItem)workItemIdMap.get(taskRunnerWorkItem.getTaskId())).getQueueInsertionTime(), ((TaskRunnerWorkItem)workItemIdMap.get(taskRunnerWorkItem.getTaskId())).getLocation()));
            }
            return runningTasks;
        }
        return allTasks;
    }

    private List<TaskStatusPlus> securedTaskStatusPlus(List<TaskStatusPlus> collectionToFilter, @Nullable String dataSource, @Nullable String type, HttpServletRequest req) {
        Function raGenerator = taskStatusPlus -> {
            String taskId = taskStatusPlus.getId();
            String taskDatasource = taskStatusPlus.getDataSource();
            if (taskDatasource == null) {
                throw new WebApplicationException(Response.serverError().entity((Object)StringUtils.format((String)"No task information found for task with id: [%s]", (Object[])new Object[]{taskId})).build());
            }
            return Collections.singletonList(new ResourceAction(new Resource(taskDatasource, ResourceType.DATASOURCE), Action.READ));
        };
        List<Object> optionalTypeFilteredList = collectionToFilter;
        if (type != null) {
            optionalTypeFilteredList = collectionToFilter.stream().filter(task -> type.equals(task.getType())).collect(Collectors.toList());
        }
        if (dataSource != null) {
            return optionalTypeFilteredList;
        }
        return Lists.newArrayList((Iterable)AuthorizationUtils.filterAuthorizedResources((HttpServletRequest)req, optionalTypeFilteredList, (Function)raGenerator, (AuthorizerMapper)this.authorizerMapper));
    }

    private static class AnyTask
    extends TaskRunnerWorkItem {
        private final String taskGroupId;
        private final String taskType;
        private final String dataSource;
        private final TaskState taskState;
        private final RunnerTaskState runnerTaskState;
        private final DateTime createdTime;
        private final DateTime queueInsertionTime;
        private final TaskLocation taskLocation;

        AnyTask(String taskId, String taskGroupId, String taskType, ListenableFuture<TaskStatus> result, String dataSource, TaskState state, RunnerTaskState runnerState, DateTime createdTime, DateTime queueInsertionTime, TaskLocation taskLocation) {
            super(taskId, result, DateTimes.EPOCH, DateTimes.EPOCH);
            this.taskGroupId = taskGroupId;
            this.taskType = taskType;
            this.dataSource = dataSource;
            this.taskState = state;
            this.runnerTaskState = runnerState;
            this.createdTime = createdTime;
            this.queueInsertionTime = queueInsertionTime;
            this.taskLocation = taskLocation;
        }

        @Override
        public TaskLocation getLocation() {
            return this.taskLocation;
        }

        @Override
        public String getTaskType() {
            return this.taskType;
        }

        @Override
        public String getDataSource() {
            return this.dataSource;
        }

        public String getTaskGroupId() {
            return this.taskGroupId;
        }

        public TaskState getTaskState() {
            return this.taskState;
        }

        public RunnerTaskState getRunnerTaskState() {
            return this.runnerTaskState;
        }

        @Override
        public DateTime getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public DateTime getQueueInsertionTime() {
            return this.queueInsertionTime;
        }

        public AnyTask withTaskState(TaskState newTaskState, RunnerTaskState runnerState, DateTime createdTime, DateTime queueInsertionTime, TaskLocation taskLocation) {
            return new AnyTask(this.getTaskId(), this.getTaskGroupId(), this.getTaskType(), this.getResult(), this.getDataSource(), newTaskState, runnerState, createdTime, queueInsertionTime, taskLocation);
        }
    }
}

