/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.Executor;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.overlord.TaskRunnerListener;
import org.apache.druid.indexing.worker.Worker;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;

public class TaskRunnerUtils {
    private static final EmittingLogger log = new EmittingLogger(TaskRunnerUtils.class);

    public static void notifyLocationChanged(Iterable<Pair<TaskRunnerListener, Executor>> listeners, String taskId, TaskLocation location) {
        log.debug("Task [%s] location changed to [%s].", new Object[]{taskId, location});
        for (Pair<TaskRunnerListener, Executor> listener : listeners) {
            try {
                ((Executor)listener.rhs).execute(() -> ((TaskRunnerListener)listener.lhs).locationChanged(taskId, location));
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Unable to notify task listener", new Object[0]).addData("taskId", (Object)taskId).addData("taskLocation", (Object)location).addData("listener", (Object)listener.toString()).emit();
            }
        }
    }

    public static void notifyStatusChanged(Iterable<Pair<TaskRunnerListener, Executor>> listeners, String taskId, TaskStatus status) {
        log.debug("Task [%s] status changed to [%s].", new Object[]{taskId, status.getStatusCode()});
        for (Pair<TaskRunnerListener, Executor> listener : listeners) {
            try {
                ((Executor)listener.rhs).execute(() -> ((TaskRunnerListener)listener.lhs).statusChanged(taskId, status));
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Unable to notify task listener", new Object[0]).addData("taskId", (Object)taskId).addData("taskStatus", (Object)status.getStatusCode()).addData("listener", (Object)listener.toString()).emit();
            }
        }
    }

    public static URL makeWorkerURL(Worker worker, String pathFormat, String ... pathParams) {
        Preconditions.checkArgument((boolean)pathFormat.startsWith("/"), (String)"path must start with '/': %s", (Object[])new Object[]{pathFormat});
        String path = StringUtils.format((String)pathFormat, (Object[])Arrays.stream(pathParams).map(StringUtils::urlEncode).toArray());
        try {
            return new URI(StringUtils.format((String)"%s://%s%s", (Object[])new Object[]{worker.getScheme(), worker.getHost(), path})).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL makeTaskLocationURL(TaskLocation taskLocation, String pathFormat, String ... pathParams) {
        Preconditions.checkArgument((boolean)pathFormat.startsWith("/"), (String)"path must start with '/': %s", (Object[])new Object[]{pathFormat});
        String path = StringUtils.format((String)pathFormat, (Object[])Arrays.stream(pathParams).map(StringUtils::urlEncode).toArray());
        try {
            return new URI(StringUtils.format((String)"http://%s:%s%s", (Object[])new Object[]{taskLocation.getHost(), taskLocation.getPort(), path})).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

