/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.SegmentLock;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TimeChunkLock;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.CriticalAction;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.LockRequest;
import org.apache.druid.indexing.overlord.LockRequestForNewSegment;
import org.apache.druid.indexing.overlord.LockResult;
import org.apache.druid.indexing.overlord.SpecificSegmentLockRequest;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.TimeChunkLockRequest;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class TaskLockbox {
    private final Map<String, NavigableMap<DateTime, SortedMap<Interval, List<TaskLockPosse>>>> running = new HashMap<String, NavigableMap<DateTime, SortedMap<Interval, List<TaskLockPosse>>>>();
    private final TaskStorage taskStorage;
    private final IndexerMetadataStorageCoordinator metadataStorageCoordinator;
    private final ReentrantLock giant = new ReentrantLock(true);
    private final Condition lockReleaseCondition = this.giant.newCondition();
    private static final EmittingLogger log = new EmittingLogger(TaskLockbox.class);
    private final Set<String> activeTasks = new HashSet<String>();

    @Inject
    public TaskLockbox(TaskStorage taskStorage, IndexerMetadataStorageCoordinator metadataStorageCoordinator) {
        this.taskStorage = taskStorage;
        this.metadataStorageCoordinator = metadataStorageCoordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncFromStorage() {
        this.giant.lock();
        try {
            HashSet<String> storedActiveTasks = new HashSet<String>();
            ArrayList<Pair> storedLocks = new ArrayList<Pair>();
            for (Task task : this.taskStorage.getActiveTasks()) {
                storedActiveTasks.add(task.getId());
                for (TaskLock taskLock : this.taskStorage.getLocks(task.getId())) {
                    storedLocks.add(Pair.of((Object)task, (Object)taskLock));
                }
            }
            Ordering<Pair<Task, TaskLock>> byVersionOrdering = new Ordering<Pair<Task, TaskLock>>(){

                public int compare(Pair<Task, TaskLock> left, Pair<Task, TaskLock> right) {
                    return ComparisonChain.start().compare((Comparable)((Object)((TaskLock)left.rhs).getVersion()), (Comparable)((Object)((TaskLock)right.rhs).getVersion())).compare((Comparable)((Object)((Task)left.lhs).getId()), (Comparable)((Object)((Task)right.lhs).getId())).result();
                }
            };
            this.running.clear();
            this.activeTasks.clear();
            this.activeTasks.addAll(storedActiveTasks);
            int taskLockCount = 0;
            for (Pair taskAndLock : byVersionOrdering.sortedCopy(storedLocks)) {
                Task task = (Task)Preconditions.checkNotNull((Object)taskAndLock.lhs, (Object)"task");
                TaskLock savedTaskLock = (TaskLock)Preconditions.checkNotNull((Object)taskAndLock.rhs, (Object)"savedTaskLock");
                if (savedTaskLock.getInterval().toDurationMillis() <= 0L) {
                    log.warn("WTF?! Got lock[%s] with empty interval for task: %s", new Object[]{savedTaskLock, task.getId()});
                    continue;
                }
                TaskLock savedTaskLockWithPriority = savedTaskLock.getPriority() == null ? savedTaskLock.withPriority(task.getPriority()) : savedTaskLock;
                TaskLockPosse taskLockPosse = this.verifyAndCreateOrFindLockPosse(task, savedTaskLockWithPriority);
                if (taskLockPosse != null) {
                    taskLockPosse.addTask(task);
                    TaskLock taskLock = taskLockPosse.getTaskLock();
                    if (savedTaskLockWithPriority.getVersion().equals(taskLock.getVersion())) {
                        ++taskLockCount;
                        log.info("Reacquired lock[%s] for task: %s", new Object[]{taskLock, task.getId()});
                        continue;
                    }
                    ++taskLockCount;
                    log.info("Could not reacquire lock on interval[%s] version[%s] (got version[%s] instead) for task: %s", new Object[]{savedTaskLockWithPriority.getInterval(), savedTaskLockWithPriority.getVersion(), taskLock.getVersion(), task.getId()});
                    continue;
                }
                throw new ISE("Could not reacquire lock on interval[%s] version[%s] for task: %s", new Object[]{savedTaskLockWithPriority.getInterval(), savedTaskLockWithPriority.getVersion(), task.getId()});
            }
            log.info("Synced %,d locks for %,d activeTasks from storage (%,d locks ignored).", new Object[]{taskLockCount, this.activeTasks.size(), storedLocks.size() - taskLockCount});
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskLockPosse verifyAndCreateOrFindLockPosse(Task task, TaskLock taskLock) {
        this.giant.lock();
        try {
            LockRequest request;
            Preconditions.checkArgument((boolean)task.getGroupId().equals(taskLock.getGroupId()), (String)"lock groupId[%s] is different from task groupId[%s]", (Object[])new Object[]{taskLock.getGroupId(), task.getGroupId()});
            Preconditions.checkArgument((boolean)task.getDataSource().equals(taskLock.getDataSource()), (String)"lock dataSource[%s] is different from task dataSource[%s]", (Object[])new Object[]{taskLock.getDataSource(), task.getDataSource()});
            int taskPriority = task.getPriority();
            int lockPriority = taskLock.getNonNullPriority();
            Preconditions.checkArgument((lockPriority == taskPriority ? 1 : 0) != 0, (String)"lock priority[%s] is different from task priority[%s]", (Object[])new Object[]{lockPriority, taskPriority});
            switch (taskLock.getGranularity()) {
                case SEGMENT: {
                    SegmentLock segmentLock = (SegmentLock)taskLock;
                    request = new SpecificSegmentLockRequest(segmentLock.getType(), segmentLock.getGroupId(), segmentLock.getDataSource(), segmentLock.getInterval(), segmentLock.getVersion(), segmentLock.getPartitionId(), taskPriority, segmentLock.isRevoked());
                    break;
                }
                case TIME_CHUNK: {
                    TimeChunkLock timeChunkLock = (TimeChunkLock)taskLock;
                    request = new TimeChunkLockRequest(timeChunkLock.getType(), timeChunkLock.getGroupId(), timeChunkLock.getDataSource(), timeChunkLock.getInterval(), timeChunkLock.getVersion(), taskPriority, timeChunkLock.isRevoked());
                    break;
                }
                default: {
                    throw new ISE("Unknown lockGranularity[%s]", new Object[]{taskLock.getGranularity()});
                }
            }
            TaskLockPosse taskLockPosse = this.createOrFindLockPosse(request);
            return taskLockPosse;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockResult lock(Task task, LockRequest request) throws InterruptedException {
        this.giant.lockInterruptibly();
        try {
            LockResult lockResult;
            while (!(lockResult = this.tryLock(task, request)).isOk()) {
                if (lockResult.isRevoked()) {
                    LockResult lockResult2 = lockResult;
                    return lockResult2;
                }
                this.lockReleaseCondition.await();
            }
            LockResult lockResult3 = lockResult;
            return lockResult3;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockResult lock(Task task, LockRequest request, long timeoutMs) throws InterruptedException {
        long nanos = TimeUnit.MILLISECONDS.toNanos(timeoutMs);
        this.giant.lockInterruptibly();
        try {
            LockResult lockResult;
            while (!(lockResult = this.tryLock(task, request)).isOk()) {
                if (nanos <= 0L || lockResult.isRevoked()) {
                    LockResult lockResult2 = lockResult;
                    return lockResult2;
                }
                nanos = this.lockReleaseCondition.awaitNanos(nanos);
            }
            LockResult lockResult3 = lockResult;
            return lockResult3;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public LockResult tryLock(Task task, LockRequest request) {
        this.giant.lock();
        try {
            LockRequest convertedRequest;
            if (!this.activeTasks.contains(task.getId())) {
                throw new ISE("Unable to grant lock to inactive Task [%s]", new Object[]{task.getId()});
            }
            Preconditions.checkArgument((request.getInterval().toDurationMillis() > 0L ? 1 : 0) != 0, (Object)"interval empty");
            SegmentIdWithShardSpec newSegmentId = null;
            if (request instanceof LockRequestForNewSegment) {
                LockRequestForNewSegment lockRequestForNewSegment = (LockRequestForNewSegment)request;
                if (lockRequestForNewSegment.getGranularity() == LockGranularity.SEGMENT) {
                    newSegmentId = this.allocateSegmentId(lockRequestForNewSegment, request.getVersion());
                    if (newSegmentId == null) {
                        LockResult lockResult = LockResult.fail(false);
                        return lockResult;
                    }
                    convertedRequest = new SpecificSegmentLockRequest(lockRequestForNewSegment, newSegmentId);
                } else {
                    convertedRequest = new TimeChunkLockRequest(lockRequestForNewSegment);
                }
            } else {
                convertedRequest = request;
            }
            TaskLockPosse posseToUse = this.createOrFindLockPosse(convertedRequest);
            if (posseToUse != null && !posseToUse.getTaskLock().isRevoked()) {
                Object lockRequestForNewSegment;
                if (request instanceof LockRequestForNewSegment && ((LockRequestForNewSegment)(lockRequestForNewSegment = (LockRequestForNewSegment)request)).getGranularity() == LockGranularity.TIME_CHUNK) {
                    if (newSegmentId != null) {
                        throw new ISE("SegmentId must be allocated after getting a timeChunk lock, but we already have [%s] before getting the lock?", new Object[]{newSegmentId});
                    }
                    newSegmentId = this.allocateSegmentId((LockRequestForNewSegment)lockRequestForNewSegment, posseToUse.getTaskLock().getVersion());
                }
                if (posseToUse.addTask(task)) {
                    log.info("Added task[%s] to TaskLock[%s]", new Object[]{task.getId(), posseToUse.getTaskLock()});
                    try {
                        this.taskStorage.addLock(task.getId(), posseToUse.getTaskLock());
                        lockRequestForNewSegment = LockResult.ok(posseToUse.getTaskLock(), newSegmentId);
                        return lockRequestForNewSegment;
                    }
                    catch (Exception e) {
                        log.makeAlert("Failed to persist lock in storage", new Object[0]).addData("task", (Object)task.getId()).addData("dataSource", (Object)posseToUse.getTaskLock().getDataSource()).addData("interval", (Object)posseToUse.getTaskLock().getInterval()).addData("version", (Object)posseToUse.getTaskLock().getVersion()).emit();
                        this.unlock(task, convertedRequest.getInterval(), posseToUse.getTaskLock().getGranularity() == LockGranularity.SEGMENT ? Integer.valueOf(((SegmentLock)posseToUse.taskLock).getPartitionId()) : null);
                        LockResult lockResult = LockResult.fail(false);
                        this.giant.unlock();
                        return lockResult;
                    }
                }
                log.info("Task[%s] already present in TaskLock[%s]", new Object[]{task.getId(), posseToUse.getTaskLock().getGroupId()});
                LockResult e = LockResult.ok(posseToUse.getTaskLock(), newSegmentId);
                return e;
            }
            boolean lockRevoked = posseToUse != null && posseToUse.getTaskLock().isRevoked();
            LockResult lockResult = LockResult.fail(lockRevoked);
            return lockResult;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskLockPosse createOrFindLockPosse(LockRequest request) {
        Preconditions.checkState((!(request instanceof LockRequestForNewSegment) ? 1 : 0) != 0, (Object)"Can't handle LockRequestForNewSegment");
        this.giant.lock();
        try {
            List<TaskLockPosse> foundPosses = this.findLockPossesOverlapsInterval(request.getDataSource(), request.getInterval());
            List<TaskLockPosse> conflictPosses = foundPosses.stream().filter(taskLockPosse -> taskLockPosse.getTaskLock().conflict(request)).collect(Collectors.toList());
            if (conflictPosses.size() > 0) {
                List reusablePosses = foundPosses.stream().filter(posse -> posse.reusableFor(request)).collect(Collectors.toList());
                if (reusablePosses.size() == 0) {
                    if (request.getType().equals((Object)TaskLockType.SHARED) && TaskLockbox.isAllSharedLocks(conflictPosses)) {
                        TaskLockPosse taskLockPosse2 = this.createNewTaskLockPosse(request);
                        return taskLockPosse2;
                    }
                    boolean allDifferentGranularity = conflictPosses.stream().allMatch(conflictPosse -> ((TaskLockPosse)conflictPosse).taskLock.getGranularity() != request.getGranularity() && conflictPosse.getTaskLock().getGroupId().equals(request.getGroupId()) && conflictPosse.getTaskLock().getInterval().equals((Object)request.getInterval()));
                    if (allDifferentGranularity) {
                        TaskLockPosse taskLockPosse3 = this.createNewTaskLockPosse(request);
                        return taskLockPosse3;
                    }
                    if (TaskLockbox.isAllRevocable(conflictPosses, request.getPriority())) {
                        conflictPosses.forEach(this::revokeLock);
                        TaskLockPosse taskLockPosse4 = this.createNewTaskLockPosse(request);
                        return taskLockPosse4;
                    }
                    log.info("Cannot create a new taskLockPosse for request[%s] because existing locks[%s] have same or higher priorities", new Object[]{request, conflictPosses});
                    TaskLockPosse taskLockPosse5 = null;
                    return taskLockPosse5;
                }
                if (reusablePosses.size() == 1) {
                    TaskLockPosse taskLockPosse6 = (TaskLockPosse)reusablePosses.get(0);
                    return taskLockPosse6;
                }
                throw new ISE("Task group[%s] has multiple locks for the same interval[%s]?", new Object[]{request.getGroupId(), request.getInterval()});
            }
            TaskLockPosse taskLockPosse7 = this.createNewTaskLockPosse(request);
            return taskLockPosse7;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskLockPosse createNewTaskLockPosse(LockRequest request) {
        this.giant.lock();
        try {
            TaskLockPosse posseToUse = new TaskLockPosse(request.toLock());
            this.running.computeIfAbsent(request.getDataSource(), k -> new TreeMap()).computeIfAbsent(request.getInterval().getStart(), k -> new TreeMap(Comparators.intervalsByStartThenEnd())).computeIfAbsent(request.getInterval(), k -> new ArrayList()).add(posseToUse);
            TaskLockPosse taskLockPosse = posseToUse;
            return taskLockPosse;
        }
        finally {
            this.giant.unlock();
        }
    }

    private SegmentIdWithShardSpec allocateSegmentId(LockRequestForNewSegment request, String version) {
        return this.metadataStorageCoordinator.allocatePendingSegment(request.getDataSource(), request.getSequenceName(), request.getPrevisousSegmentId(), request.getInterval(), request.getShardSpecFactory(), version, request.isSkipSegmentLineageCheck());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doInCriticalSection(Task task, List<Interval> intervals, CriticalAction<T> action) throws Exception {
        this.giant.lock();
        try {
            T t = action.perform(this.isTaskLocksValid(task, intervals));
            return t;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTaskLocksValid(Task task, List<Interval> intervals) {
        this.giant.lock();
        try {
            boolean bl = intervals.stream().allMatch(interval -> {
                List<TaskLockPosse> lockPosses = this.getOnlyTaskLockPosseContainingInterval(task, (Interval)interval);
                return lockPosses.stream().map(TaskLockPosse::getTaskLock).allMatch(lock -> !lock.isRevoked() && lock.getType() != TaskLockType.SHARED);
            });
            return bl;
        }
        finally {
            this.giant.unlock();
        }
    }

    private void revokeLock(TaskLockPosse lockPosse) {
        this.giant.lock();
        try {
            lockPosse.forEachTask(taskId -> this.revokeLock((String)taskId, lockPosse.getTaskLock()));
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revokeLock(String taskId, TaskLock lock) {
        this.giant.lock();
        try {
            if (!this.activeTasks.contains(taskId)) {
                throw new ISE("Cannot revoke lock for inactive task[%s]", new Object[]{taskId});
            }
            Task task = (Task)this.taskStorage.getTask(taskId).orNull();
            if (task == null) {
                throw new ISE("Cannot revoke lock for unknown task[%s]", new Object[]{taskId});
            }
            log.info("Revoking task lock[%s] for task[%s]", new Object[]{lock, taskId});
            if (lock.isRevoked()) {
                log.warn("TaskLock[%s] is already revoked", new Object[]{lock});
            } else {
                TaskLock revokedLock = lock.revokedCopy();
                this.taskStorage.replaceLock(taskId, lock, revokedLock);
                List possesHolder = (List)((SortedMap)this.running.get(task.getDataSource()).get(lock.getInterval().getStart())).get(lock.getInterval());
                TaskLockPosse foundPosse = possesHolder.stream().filter(posse -> posse.getTaskLock().equals(lock)).findFirst().orElseThrow(() -> new ISE("Failed to find lock posse for lock[%s]", new Object[]{lock}));
                possesHolder.remove(foundPosse);
                possesHolder.add(foundPosse.withTaskLock(revokedLock));
                log.info("Revoked taskLock[%s]", new Object[]{lock});
            }
        }
        finally {
            this.giant.unlock();
        }
    }

    public List<TaskLock> findLocksForTask(Task task) {
        this.giant.lock();
        try {
            List list = Lists.transform(this.findLockPossesForTask(task), (Function)new Function<TaskLockPosse, TaskLock>(){

                public TaskLock apply(TaskLockPosse taskLockPosse) {
                    return taskLockPosse.getTaskLock();
                }
            });
            return list;
        }
        finally {
            this.giant.unlock();
        }
    }

    public void unlock(Task task, Interval interval) {
        this.unlock(task, interval, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Task task, Interval interval, @Nullable Integer partitionId) {
        this.giant.lock();
        try {
            String dataSource = task.getDataSource();
            NavigableMap<DateTime, SortedMap<Interval, List<TaskLockPosse>>> dsRunning = this.running.get(task.getDataSource());
            if (dsRunning == null || dsRunning.isEmpty()) {
                return;
            }
            SortedMap intervalToPosses = (SortedMap)dsRunning.get(interval.getStart());
            if (intervalToPosses == null || intervalToPosses.isEmpty()) {
                return;
            }
            List possesHolder = (List)intervalToPosses.get(interval);
            if (possesHolder == null || possesHolder.isEmpty()) {
                return;
            }
            List posses = possesHolder.stream().filter(posse -> posse.containsTask(task)).collect(Collectors.toList());
            for (TaskLockPosse taskLockPosse : posses) {
                TaskLock taskLock = taskLockPosse.getTaskLock();
                boolean match = partitionId == null && taskLock.getGranularity() == LockGranularity.TIME_CHUNK || partitionId != null && taskLock.getGranularity() == LockGranularity.SEGMENT && ((SegmentLock)taskLock).getPartitionId() == partitionId.intValue();
                if (!match) continue;
                log.info("Removing task[%s] from TaskLock[%s]", new Object[]{task.getId(), taskLock});
                boolean removed = taskLockPosse.removeTask(task);
                if (taskLockPosse.isTasksEmpty()) {
                    log.info("TaskLock is now empty: %s", new Object[]{taskLock});
                    possesHolder.remove(taskLockPosse);
                }
                if (possesHolder.isEmpty()) {
                    intervalToPosses.remove(interval);
                }
                if (intervalToPosses.isEmpty()) {
                    dsRunning.remove(interval.getStart());
                }
                if (this.running.get(dataSource).size() == 0) {
                    this.running.remove(dataSource);
                }
                this.lockReleaseCondition.signalAll();
                try {
                    this.taskStorage.removeLock(task.getId(), taskLock);
                }
                catch (Exception e) {
                    log.makeAlert((Throwable)e, "Failed to clean up lock from storage", new Object[0]).addData("task", (Object)task.getId()).addData("dataSource", (Object)taskLock.getDataSource()).addData("interval", (Object)taskLock.getInterval()).addData("version", (Object)taskLock.getVersion()).emit();
                }
                if (removed) continue;
                log.makeAlert("Lock release without acquire", new Object[0]).addData("task", (Object)task.getId()).addData("interval", (Object)interval).emit();
            }
        }
        finally {
            this.giant.unlock();
        }
    }

    public void add(Task task) {
        this.giant.lock();
        try {
            log.info("Adding task[%s] to activeTasks", new Object[]{task.getId()});
            this.activeTasks.add(task.getId());
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Task task) {
        this.giant.lock();
        try {
            try {
                log.info("Removing task[%s] from activeTasks", new Object[]{task.getId()});
                for (TaskLockPosse taskLockPosse : this.findLockPossesForTask(task)) {
                    this.unlock(task, taskLockPosse.getTaskLock().getInterval(), taskLockPosse.getTaskLock().getGranularity() == LockGranularity.SEGMENT ? Integer.valueOf(((SegmentLock)taskLockPosse.taskLock).getPartitionId()) : null);
                }
            }
            finally {
                this.activeTasks.remove(task.getId());
            }
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaskLockPosse> findLockPossesForTask(Task task) {
        this.giant.lock();
        try {
            NavigableMap<DateTime, SortedMap<Interval, List<TaskLockPosse>>> dsRunning = this.running.get(task.getDataSource());
            if (dsRunning == null) {
                ImmutableList immutableList = ImmutableList.of();
                return immutableList;
            }
            List<TaskLockPosse> list = dsRunning.values().stream().flatMap(map -> map.values().stream()).flatMap(Collection::stream).filter(taskLockPosse -> taskLockPosse.containsTask(task)).collect(Collectors.toList());
            return list;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaskLockPosse> findLockPossesContainingInterval(String dataSource, Interval interval) {
        this.giant.lock();
        try {
            List<TaskLockPosse> intervalOverlapsPosses = this.findLockPossesOverlapsInterval(dataSource, interval);
            List<TaskLockPosse> list = intervalOverlapsPosses.stream().filter(taskLockPosse -> ((TaskLockPosse)taskLockPosse).taskLock.getInterval().contains((ReadableInterval)interval)).collect(Collectors.toList());
            return list;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaskLockPosse> findLockPossesOverlapsInterval(String dataSource, Interval interval) {
        this.giant.lock();
        try {
            NavigableMap<DateTime, SortedMap<Interval, List<TaskLockPosse>>> dsRunning = this.running.get(dataSource);
            if (dsRunning == null) {
                List<TaskLockPosse> list = Collections.emptyList();
                return list;
            }
            NavigableSet<DateTime> dsLockbox = dsRunning.navigableKeySet();
            Iterable searchStartTimes = Iterables.concat(Collections.singletonList(dsLockbox.floor(interval.getStart())), dsLockbox.subSet(interval.getStart(), false, interval.getEnd(), false));
            List<TaskLockPosse> list = StreamSupport.stream(searchStartTimes.spliterator(), false).filter(Objects::nonNull).map(dsRunning::get).filter(Objects::nonNull).flatMap(sortedMap -> sortedMap.entrySet().stream()).filter(entry -> ((Interval)entry.getKey()).overlaps((ReadableInterval)interval)).flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList());
            return list;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    List<TaskLockPosse> getOnlyTaskLockPosseContainingInterval(Task task, Interval interval) {
        this.giant.lock();
        try {
            List<TaskLockPosse> list = this.getOnlyTaskLockPosseContainingInterval(task, interval, Collections.emptySet());
            return list;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    List<TaskLockPosse> getOnlyTaskLockPosseContainingInterval(Task task, Interval interval, Set<Integer> partitionIds) {
        this.giant.lock();
        try {
            List<TaskLockPosse> filteredPosses = this.findLockPossesContainingInterval(task.getDataSource(), interval).stream().filter(lockPosse -> lockPosse.containsTask(task)).collect(Collectors.toList());
            if (filteredPosses.isEmpty()) {
                throw new ISE("Cannot find locks for task[%s] and interval[%s]", new Object[]{task.getId(), interval});
            }
            if (filteredPosses.size() > 1) {
                if (filteredPosses.stream().anyMatch(posse -> posse.getTaskLock().getGranularity() == LockGranularity.TIME_CHUNK)) {
                    throw new ISE("There are multiple timeChunk lockPosses for task[%s] and interval[%s]?", new Object[]{task.getId(), interval});
                }
                HashMap<Integer, TaskLockPosse> partitionIdsOfLocks = new HashMap<Integer, TaskLockPosse>();
                for (TaskLockPosse posse2 : filteredPosses) {
                    SegmentLock segmentLock = (SegmentLock)posse2.getTaskLock();
                    partitionIdsOfLocks.put(segmentLock.getPartitionId(), posse2);
                }
                if (partitionIds.stream().allMatch(partitionIdsOfLocks::containsKey)) {
                    List list = partitionIds.stream().map(partitionIdsOfLocks::get).collect(Collectors.toList());
                    return list;
                }
                throw new ISE("Task[%s] doesn't have locks for interval[%s] partitions[%]", new Object[]{task.getId(), interval, partitionIds.stream().filter(pid -> !partitionIdsOfLocks.containsKey(pid)).collect(Collectors.toList())});
            }
            List<TaskLockPosse> list = filteredPosses;
            return list;
        }
        finally {
            this.giant.unlock();
        }
    }

    @VisibleForTesting
    Set<String> getActiveTasks() {
        return this.activeTasks;
    }

    @VisibleForTesting
    Map<String, NavigableMap<DateTime, SortedMap<Interval, List<TaskLockPosse>>>> getAllLocks() {
        return this.running;
    }

    private static boolean isAllSharedLocks(List<TaskLockPosse> lockPosses) {
        return lockPosses.stream().allMatch(taskLockPosse -> taskLockPosse.getTaskLock().getType().equals((Object)TaskLockType.SHARED));
    }

    private static boolean isAllRevocable(List<TaskLockPosse> lockPosses, int tryLockPriority) {
        return lockPosses.stream().allMatch(taskLockPosse -> TaskLockbox.isRevocable(taskLockPosse, tryLockPriority));
    }

    private static boolean isRevocable(TaskLockPosse lockPosse, int tryLockPriority) {
        TaskLock existingLock = lockPosse.getTaskLock();
        return existingLock.isRevoked() || existingLock.getNonNullPriority() < tryLockPriority;
    }

    static class TaskLockPosse {
        private final TaskLock taskLock;
        private final Set<String> taskIds;

        TaskLockPosse(TaskLock taskLock) {
            this.taskLock = taskLock;
            this.taskIds = new HashSet<String>();
        }

        private TaskLockPosse(TaskLock taskLock, Set<String> taskIds) {
            this.taskLock = taskLock;
            this.taskIds = new HashSet<String>(taskIds);
        }

        TaskLockPosse withTaskLock(TaskLock taskLock) {
            return new TaskLockPosse(taskLock, this.taskIds);
        }

        TaskLock getTaskLock() {
            return this.taskLock;
        }

        boolean addTask(Task task) {
            if (this.taskLock.getType() == TaskLockType.EXCLUSIVE) {
                Preconditions.checkArgument((boolean)this.taskLock.getGroupId().equals(task.getGroupId()), (String)"groupId[%s] of task[%s] is different from the existing lockPosse's groupId[%s]", (Object[])new Object[]{task.getGroupId(), task.getId(), this.taskLock.getGroupId()});
            }
            Preconditions.checkArgument((this.taskLock.getNonNullPriority() == task.getPriority() ? 1 : 0) != 0, (String)"priority[%s] of task[%s] is different from the existing lockPosse's priority[%s]", (Object[])new Object[]{task.getPriority(), task.getId(), this.taskLock.getNonNullPriority()});
            return this.taskIds.add(task.getId());
        }

        boolean containsTask(Task task) {
            Preconditions.checkNotNull((Object)task, (Object)"task");
            return this.taskIds.contains(task.getId());
        }

        boolean removeTask(Task task) {
            Preconditions.checkNotNull((Object)task, (Object)"task");
            return this.taskIds.remove(task.getId());
        }

        boolean isTasksEmpty() {
            return this.taskIds.isEmpty();
        }

        boolean reusableFor(LockRequest request) {
            if (this.taskLock.getType() == request.getType() && this.taskLock.getGranularity() == request.getGranularity()) {
                switch (this.taskLock.getType()) {
                    case SHARED: {
                        return false;
                    }
                    case EXCLUSIVE: {
                        if (request instanceof TimeChunkLockRequest) {
                            return this.taskLock.getInterval().contains((ReadableInterval)request.getInterval()) && this.taskLock.getGroupId().equals(request.getGroupId());
                        }
                        if (request instanceof SpecificSegmentLockRequest) {
                            SegmentLock segmentLock = (SegmentLock)this.taskLock;
                            SpecificSegmentLockRequest specificSegmentLockRequest = (SpecificSegmentLockRequest)request;
                            return segmentLock.getInterval().contains((ReadableInterval)specificSegmentLockRequest.getInterval()) && segmentLock.getGroupId().equals(specificSegmentLockRequest.getGroupId()) && specificSegmentLockRequest.getPartitionId() == segmentLock.getPartitionId();
                        }
                        throw new ISE("Unknown request type[%s]", new Object[]{request});
                    }
                }
                throw new ISE("Unknown lock type[%s]", new Object[]{this.taskLock.getType()});
            }
            return false;
        }

        void forEachTask(Consumer<String> action) {
            Preconditions.checkNotNull(action, (Object)"action");
            this.taskIds.forEach(action);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !this.getClass().equals(o.getClass())) {
                return false;
            }
            TaskLockPosse that = (TaskLockPosse)o;
            return Objects.equals(this.taskLock, that.taskLock) && Objects.equals(this.taskIds, that.taskIds);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.taskLock, this.taskIds});
        }

        public String toString() {
            return com.google.common.base.Objects.toStringHelper((Object)this).add("taskLock", (Object)this.taskLock).add("taskIds", this.taskIds).toString();
        }
    }
}

