/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.LockRequest;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.timeline.partition.ShardSpecFactory;
import org.joda.time.Interval;

public class LockRequestForNewSegment
implements LockRequest {
    private final LockGranularity lockGranularity;
    private final TaskLockType lockType;
    private final String groupId;
    private final String dataSource;
    private final Interval interval;
    private final ShardSpecFactory shardSpecFactory;
    private final int priority;
    private final String sequenceName;
    @Nullable
    private final String previsousSegmentId;
    private final boolean skipSegmentLineageCheck;
    private String version;

    public LockRequestForNewSegment(LockGranularity lockGranularity, TaskLockType lockType, String groupId, String dataSource, Interval interval, ShardSpecFactory shardSpecFactory, int priority, String sequenceName, @Nullable String previsousSegmentId, boolean skipSegmentLineageCheck) {
        this.lockGranularity = lockGranularity;
        this.lockType = lockType;
        this.groupId = groupId;
        this.dataSource = dataSource;
        this.interval = interval;
        this.shardSpecFactory = shardSpecFactory;
        this.priority = priority;
        this.sequenceName = sequenceName;
        this.previsousSegmentId = previsousSegmentId;
        this.skipSegmentLineageCheck = skipSegmentLineageCheck;
    }

    @VisibleForTesting
    public LockRequestForNewSegment(LockGranularity lockGranularity, TaskLockType lockType, Task task, Interval interval, ShardSpecFactory shardSpecFactory, String sequenceName, @Nullable String previsousSegmentId, boolean skipSegmentLineageCheck) {
        this(lockGranularity, lockType, task.getGroupId(), task.getDataSource(), interval, shardSpecFactory, task.getPriority(), sequenceName, previsousSegmentId, skipSegmentLineageCheck);
    }

    @Override
    public LockGranularity getGranularity() {
        return this.lockGranularity;
    }

    @Override
    public TaskLockType getType() {
        return this.lockType;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getDataSource() {
        return this.dataSource;
    }

    @Override
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public ShardSpecFactory getShardSpecFactory() {
        return this.shardSpecFactory;
    }

    @Override
    public String getVersion() {
        if (this.version == null) {
            this.version = DateTimes.nowUtc().toString();
        }
        return this.version;
    }

    @Override
    public boolean isRevoked() {
        return false;
    }

    @Override
    public TaskLock toLock() {
        throw new UnsupportedOperationException("This lockRequest must be converted to SpecificSegmentLockRequest or TimeChunkLockRequest first to convert to TaskLock");
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    @Nullable
    public String getPrevisousSegmentId() {
        return this.previsousSegmentId;
    }

    public boolean isSkipSegmentLineageCheck() {
        return this.skipSegmentLineageCheck;
    }

    public String toString() {
        return "LockRequestForNewSegment{lockGranularity=" + (Object)((Object)this.lockGranularity) + ", lockType=" + (Object)((Object)this.lockType) + ", groupId='" + this.groupId + '\'' + ", dataSource='" + this.dataSource + '\'' + ", interval=" + this.interval + ", shardSpecFactory=" + this.shardSpecFactory + ", priority=" + this.priority + ", sequenceName='" + this.sequenceName + '\'' + ", previsousSegmentId='" + this.previsousSegmentId + '\'' + ", skipSegmentLineageCheck=" + this.skipSegmentLineageCheck + '}';
    }
}

