/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.input;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.IntermediateRowParsingReader;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.indexing.input.DruidSegmentInputEntity;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.realtime.firehose.WindowedStorageAdapter;
import org.joda.time.DateTime;

public class DruidSegmentReader
extends IntermediateRowParsingReader<Map<String, Object>> {
    private final DruidSegmentInputEntity source;
    private final IndexIO indexIO;
    private final List<String> dimensions;
    private final List<String> metrics;
    private final DimFilter dimFilter;
    private final File temporaryDirectory;

    DruidSegmentReader(InputEntity source, IndexIO indexIO, List<String> dimensions, List<String> metrics, DimFilter dimFilter, File temporaryDirectory) {
        Preconditions.checkArgument((boolean)(source instanceof DruidSegmentInputEntity));
        this.source = (DruidSegmentInputEntity)source;
        this.indexIO = indexIO;
        this.dimensions = dimensions;
        this.metrics = metrics;
        this.dimFilter = dimFilter;
        this.temporaryDirectory = temporaryDirectory;
    }

    protected CloseableIterator<Map<String, Object>> intermediateRowIterator() throws IOException {
        InputEntity.CleanableFile segmentFile = this.source.fetch(this.temporaryDirectory, null);
        WindowedStorageAdapter storageAdapter = new WindowedStorageAdapter((StorageAdapter)new QueryableIndexStorageAdapter(this.indexIO.loadIndex(segmentFile.file())), this.source.getIntervalFilter());
        Sequence cursors = storageAdapter.getAdapter().makeCursors(Filters.toFilter((DimFilter)this.dimFilter), storageAdapter.getInterval(), VirtualColumns.EMPTY, Granularities.ALL, false, null);
        Sequence sequence = Sequences.concat((Sequence)Sequences.map((Sequence)cursors, this::cursorToSequence));
        return DruidSegmentReader.makeCloseableIteratorFromSequenceAndSegmentFile((Sequence<Map<String, Object>>)sequence, segmentFile);
    }

    protected List<InputRow> parseInputRows(Map<String, Object> intermediateRow) throws ParseException {
        DateTime timestamp = (DateTime)intermediateRow.get("timestamp");
        return Collections.singletonList(new MapBasedInputRow(timestamp.getMillis(), this.dimensions, intermediateRow));
    }

    protected Map<String, Object> toMap(Map<String, Object> intermediateRow) {
        return intermediateRow;
    }

    private Sequence<Map<String, Object>> cursorToSequence(Cursor cursor) {
        return Sequences.simple(() -> new IntermediateRowFromCursorIterator(cursor, this.dimensions, this.metrics));
    }

    private static CloseableIterator<Map<String, Object>> makeCloseableIteratorFromSequenceAndSegmentFile(final Sequence<Map<String, Object>> sequence, final InputEntity.CleanableFile segmentFile) {
        return new CloseableIterator<Map<String, Object>>(){
            Yielder<Map<String, Object>> rowYielder;
            {
                this.rowYielder = Yielders.each((Sequence)sequence);
            }

            public boolean hasNext() {
                return !this.rowYielder.isDone();
            }

            public Map<String, Object> next() {
                Map row = (Map)this.rowYielder.get();
                this.rowYielder = this.rowYielder.next(null);
                return row;
            }

            public void close() throws IOException {
                segmentFile.close();
            }
        };
    }

    private static class IntermediateRowFromCursorIterator
    implements Iterator<Map<String, Object>> {
        private final Cursor cursor;
        private final BaseLongColumnValueSelector timestampColumnSelector;
        private final Map<String, DimensionSelector> dimSelectors;
        private final Map<String, BaseObjectColumnValueSelector> metSelectors;

        public IntermediateRowFromCursorIterator(Cursor cursor, List<String> dimensionNames, List<String> metricNames) {
            this.cursor = cursor;
            this.timestampColumnSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("__time");
            this.dimSelectors = new HashMap<String, DimensionSelector>();
            for (String dim : dimensionNames) {
                DimensionSelector dimSelector = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec(dim, dim));
                if (dimSelector == null) continue;
                this.dimSelectors.put(dim, dimSelector);
            }
            this.metSelectors = new HashMap<String, BaseObjectColumnValueSelector>();
            for (String metric : metricNames) {
                ColumnValueSelector metricSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector(metric);
                this.metSelectors.put(metric, (BaseObjectColumnValueSelector)metricSelector);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.cursor.isDone();
        }

        @Override
        public Map<String, Object> next() {
            DimensionSelector selector;
            LinkedHashMap theEvent = Maps.newLinkedHashMap();
            long timestamp = this.timestampColumnSelector.getLong();
            theEvent.put("timestamp", DateTimes.utc((long)timestamp));
            for (Map.Entry<String, DimensionSelector> entry : this.dimSelectors.entrySet()) {
                String dim = entry.getKey();
                selector = entry.getValue();
                IndexedInts vals = selector.getRow();
                int valsSize = vals.size();
                if (valsSize == 1) {
                    String dimVal = selector.lookupName(vals.get(0));
                    theEvent.put(dim, dimVal);
                    continue;
                }
                if (valsSize <= 1) continue;
                ArrayList<String> dimVals = new ArrayList<String>(valsSize);
                for (int i = 0; i < valsSize; ++i) {
                    dimVals.add(selector.lookupName(vals.get(i)));
                }
                theEvent.put(dim, dimVals);
            }
            for (Map.Entry<String, DimensionSelector> entry : this.metSelectors.entrySet()) {
                String metric = entry.getKey();
                selector = (BaseObjectColumnValueSelector)entry.getValue();
                Object value = selector.getObject();
                if (value == null) continue;
                theEvent.put(metric, value);
            }
            this.cursor.advance();
            return theEvent;
        }
    }
}

