/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.input;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.data.input.AbstractInputSource;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.SegmentsSplitHintSpec;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.InputEntityIteratingReader;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.indexing.common.ReingestionTimelineUtils;
import org.apache.druid.indexing.common.RetryPolicy;
import org.apache.druid.indexing.common.RetryPolicyFactory;
import org.apache.druid.indexing.common.SegmentLoaderFactory;
import org.apache.druid.indexing.firehose.WindowedSegmentId;
import org.apache.druid.indexing.input.DruidSegmentInputEntity;
import org.apache.druid.indexing.input.DruidSegmentInputFormat;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.loading.SegmentLoader;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.PartitionHolder;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class DruidInputSource
extends AbstractInputSource
implements SplittableInputSource<List<WindowedSegmentId>> {
    private static final Logger LOG = new Logger(DruidInputSource.class);
    private final String dataSource;
    @Nullable
    private final Interval interval;
    @Nullable
    private final List<WindowedSegmentId> segmentIds;
    private final DimFilter dimFilter;
    private final List<String> dimensions;
    private final List<String> metrics;
    private final IndexIO indexIO;
    private final CoordinatorClient coordinatorClient;
    private final SegmentLoaderFactory segmentLoaderFactory;
    private final RetryPolicyFactory retryPolicyFactory;

    @JsonCreator
    public DruidInputSource(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") @Nullable Interval interval, @JsonProperty(value="segments") @Nullable List<WindowedSegmentId> segmentIds, @JsonProperty(value="filter") DimFilter dimFilter, @Nullable @JsonProperty(value="dimensions") List<String> dimensions, @Nullable @JsonProperty(value="metrics") List<String> metrics, @JacksonInject IndexIO indexIO, @JacksonInject CoordinatorClient coordinatorClient, @JacksonInject SegmentLoaderFactory segmentLoaderFactory, @JacksonInject RetryPolicyFactory retryPolicyFactory) {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        if (interval == null && segmentIds == null || interval != null && segmentIds != null) {
            throw new IAE("Specify exactly one of 'interval' and 'segments'", new Object[0]);
        }
        this.dataSource = dataSource;
        this.interval = interval;
        this.segmentIds = segmentIds;
        this.dimFilter = dimFilter;
        this.dimensions = dimensions;
        this.metrics = metrics;
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"null IndexIO");
        this.coordinatorClient = (CoordinatorClient)Preconditions.checkNotNull((Object)coordinatorClient, (Object)"null CoordinatorClient");
        this.segmentLoaderFactory = (SegmentLoaderFactory)Preconditions.checkNotNull((Object)segmentLoaderFactory, (Object)"null SegmentLoaderFactory");
        this.retryPolicyFactory = (RetryPolicyFactory)Preconditions.checkNotNull((Object)retryPolicyFactory, (Object)"null RetryPolicyFactory");
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @Nullable
    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Nullable
    @JsonProperty(value="segments")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<WindowedSegmentId> getSegmentIds() {
        return this.segmentIds;
    }

    @JsonProperty(value="filter")
    public DimFilter getDimFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty
    public List<String> getMetrics() {
        return this.metrics;
    }

    protected InputSourceReader fixedFormatReader(InputRowSchema inputRowSchema, @Nullable File temporaryDirectory) {
        SegmentLoader segmentLoader = this.segmentLoaderFactory.manufacturate(temporaryDirectory);
        List<TimelineObjectHolder<String, DataSegment>> timeline = this.createTimeline();
        Stream entityStream = this.createTimeline().stream().flatMap(holder -> {
            PartitionHolder partitionHolder = holder.getObject();
            return partitionHolder.stream().map(chunk -> new DruidSegmentInputEntity(segmentLoader, (DataSegment)chunk.getObject(), holder.getInterval()));
        });
        List<Object> effectiveDimensions = this.dimensions == null ? ReingestionTimelineUtils.getUniqueDimensions(timeline, inputRowSchema.getDimensionsSpec().getDimensionExclusions()) : (inputRowSchema.getDimensionsSpec().hasCustomDimensions() ? inputRowSchema.getDimensionsSpec().getDimensionNames() : this.dimensions);
        List<String> effectiveMetrics = this.metrics == null ? ReingestionTimelineUtils.getUniqueMetrics(timeline) : this.metrics;
        DruidSegmentInputFormat inputFormat = new DruidSegmentInputFormat(this.indexIO, this.dimFilter, (List<String>)effectiveDimensions, effectiveMetrics);
        return new InputEntityIteratingReader(inputRowSchema, (InputFormat)inputFormat, entityStream, temporaryDirectory);
    }

    private List<TimelineObjectHolder<String, DataSegment>> createTimeline() {
        if (this.interval == null) {
            return DruidInputSource.getTimelineForSegmentIds(this.coordinatorClient, this.dataSource, this.segmentIds);
        }
        return DruidInputSource.getTimelineForInterval(this.coordinatorClient, this.retryPolicyFactory, this.dataSource, this.interval);
    }

    public Stream<InputSplit<List<WindowedSegmentId>>> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        if (this.segmentIds == null) {
            return DruidInputSource.createSplits(this.coordinatorClient, this.retryPolicyFactory, this.dataSource, this.interval, (SplitHintSpec)(splitHintSpec == null ? new SegmentsSplitHintSpec(null) : splitHintSpec)).stream();
        }
        return Stream.of(new InputSplit(this.segmentIds));
    }

    public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        if (this.segmentIds == null) {
            return DruidInputSource.createSplits(this.coordinatorClient, this.retryPolicyFactory, this.dataSource, this.interval, (SplitHintSpec)(splitHintSpec == null ? new SegmentsSplitHintSpec(null) : splitHintSpec)).size();
        }
        return 1;
    }

    public SplittableInputSource<List<WindowedSegmentId>> withSplit(InputSplit<List<WindowedSegmentId>> split) {
        return new DruidInputSource(this.dataSource, null, (List)split.get(), this.dimFilter, this.dimensions, this.metrics, this.indexIO, this.coordinatorClient, this.segmentLoaderFactory, this.retryPolicyFactory);
    }

    public boolean needsFormat() {
        return false;
    }

    public static List<InputSplit<List<WindowedSegmentId>>> createSplits(CoordinatorClient coordinatorClient, RetryPolicyFactory retryPolicyFactory, String dataSource, Interval interval, SplitHintSpec splitHintSpec) {
        long maxInputSegmentBytesPerTask;
        if (!(splitHintSpec instanceof SegmentsSplitHintSpec)) {
            LOG.warn("Given splitHintSpec[%s] is not a SegmentsSplitHintSpec. Ignoring it.", new Object[]{splitHintSpec});
            maxInputSegmentBytesPerTask = new SegmentsSplitHintSpec(null).getMaxInputSegmentBytesPerTask();
        } else {
            maxInputSegmentBytesPerTask = ((SegmentsSplitHintSpec)splitHintSpec).getMaxInputSegmentBytesPerTask();
        }
        List<TimelineObjectHolder<String, DataSegment>> timelineSegments = DruidInputSource.getTimelineForInterval(coordinatorClient, retryPolicyFactory, dataSource, interval);
        ArrayList<InputSplit<List<WindowedSegmentId>>> splits = new ArrayList<InputSplit<List<WindowedSegmentId>>>();
        ArrayList<WindowedSegmentId> currentSplit = new ArrayList<WindowedSegmentId>();
        HashMap<DataSegment, WindowedSegmentId> windowedSegmentIds = new HashMap<DataSegment, WindowedSegmentId>();
        long bytesInCurrentSplit = 0L;
        for (TimelineObjectHolder<String, DataSegment> timelineHolder : timelineSegments) {
            for (PartitionChunk chunk : timelineHolder.getObject()) {
                DataSegment segment = (DataSegment)chunk.getObject();
                WindowedSegmentId existingWindowedSegmentId = (WindowedSegmentId)windowedSegmentIds.get(segment);
                if (existingWindowedSegmentId != null) {
                    existingWindowedSegmentId.getIntervals().add(timelineHolder.getInterval());
                    continue;
                }
                ArrayList<Interval> intervals = new ArrayList<Interval>();
                intervals.add(timelineHolder.getInterval());
                WindowedSegmentId newWindowedSegmentId = new WindowedSegmentId(segment.getId().toString(), intervals);
                windowedSegmentIds.put(segment, newWindowedSegmentId);
                long segmentBytes = segment.getSize();
                if (bytesInCurrentSplit + segmentBytes > maxInputSegmentBytesPerTask && !currentSplit.isEmpty()) {
                    splits.add((InputSplit<List<WindowedSegmentId>>)new InputSplit(currentSplit));
                    currentSplit = new ArrayList();
                    bytesInCurrentSplit = 0L;
                }
                if (segmentBytes > maxInputSegmentBytesPerTask) {
                    Preconditions.checkState((currentSplit.isEmpty() && bytesInCurrentSplit == 0L ? 1 : 0) != 0);
                    splits.add((InputSplit<List<WindowedSegmentId>>)new InputSplit(Collections.singletonList(newWindowedSegmentId)));
                    continue;
                }
                currentSplit.add(newWindowedSegmentId);
                bytesInCurrentSplit += segmentBytes;
            }
        }
        if (!currentSplit.isEmpty()) {
            splits.add((InputSplit<List<WindowedSegmentId>>)new InputSplit(currentSplit));
        }
        return splits;
    }

    public static List<TimelineObjectHolder<String, DataSegment>> getTimelineForInterval(CoordinatorClient coordinatorClient, RetryPolicyFactory retryPolicyFactory, String dataSource, Interval interval) {
        Collection usedSegments;
        Preconditions.checkNotNull((Object)interval);
        RetryPolicy retryPolicy = retryPolicyFactory.makeRetryPolicy();
        while (true) {
            try {
                usedSegments = coordinatorClient.getDatabaseSegmentDataSourceSegments(dataSource, Collections.singletonList(interval));
                break;
            }
            catch (Throwable e) {
                LOG.warn(e, "Exception getting database segments", new Object[0]);
                Duration delay = retryPolicy.getAndIncrementRetryDelay();
                if (delay == null) {
                    throw e;
                }
                long sleepTime = DruidInputSource.jitter(delay.getMillis());
                LOG.info("Will try again in [%s].", new Object[]{new Duration(sleepTime).toString()});
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
        return VersionedIntervalTimeline.forSegments((Iterable)usedSegments).lookup(interval);
    }

    public static List<TimelineObjectHolder<String, DataSegment>> getTimelineForSegmentIds(CoordinatorClient coordinatorClient, String dataSource, List<WindowedSegmentId> segmentIds) {
        TreeMap<Interval, TimelineObjectHolder> timeline = new TreeMap<Interval, TimelineObjectHolder>(Comparators.intervalsByStartThenEnd());
        for (WindowedSegmentId windowedSegmentId : (List)Preconditions.checkNotNull(segmentIds, (Object)"segmentIds")) {
            DataSegment segment = coordinatorClient.getDatabaseSegmentDataSourceSegment(dataSource, windowedSegmentId.getSegmentId());
            for (Interval interval : windowedSegmentId.getIntervals()) {
                TimelineObjectHolder existingHolder = (TimelineObjectHolder)timeline.get(interval);
                if (existingHolder != null) {
                    if (!((String)existingHolder.getVersion()).equals(segment.getVersion())) {
                        throw new ISE("Timeline segments with the same interval should have the same version: existing version[%s] vs new segment[%s]", new Object[]{existingHolder.getVersion(), segment});
                    }
                    existingHolder.getObject().add(segment.getShardSpec().createChunk((Object)segment));
                    continue;
                }
                timeline.put(interval, new TimelineObjectHolder(interval, segment.getInterval(), (Object)segment.getVersion(), new PartitionHolder(segment.getShardSpec().createChunk((Object)segment))));
            }
        }
        Interval lastInterval = null;
        for (Interval interval : timeline.keySet()) {
            if (lastInterval != null && interval.overlaps((ReadableInterval)lastInterval)) {
                throw new IAE("Distinct intervals in input segments may not overlap: [%s] vs [%s]", new Object[]{lastInterval, interval});
            }
            lastInterval = interval;
        }
        return new ArrayList<TimelineObjectHolder<String, DataSegment>>(timeline.values());
    }

    private static long jitter(long input) {
        double jitter = ThreadLocalRandom.current().nextGaussian() * (double)input / 4.0;
        long retval = input + (long)jitter;
        return retval < 0L ? 0L : retval;
    }
}

