/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.tasklogs;

import com.google.common.base.Optional;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.druid.indexing.common.config.FileTaskLogsConfig;
import org.apache.druid.indexing.common.tasklogs.LogUtils;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.tasklogs.TaskLogs;

public class FileTaskLogs
implements TaskLogs {
    private static final Logger log = new Logger(FileTaskLogs.class);
    private final FileTaskLogsConfig config;

    @Inject
    public FileTaskLogs(FileTaskLogsConfig config) {
        this.config = config;
    }

    public void pushTaskLog(String taskid, File file) throws IOException {
        if (!this.config.getDirectory().exists() && !this.config.getDirectory().mkdirs()) {
            throw new IOE("Unable to create task log dir[%s]", new Object[]{this.config.getDirectory()});
        }
        File outputFile = this.fileForTask(taskid, file.getName());
        Files.copy((File)file, (File)outputFile);
        log.info("Wrote task log to: %s", new Object[]{outputFile});
    }

    public void pushTaskReports(String taskid, File reportFile) throws IOException {
        if (!this.config.getDirectory().exists() && !this.config.getDirectory().mkdirs()) {
            throw new IOE("Unable to create task report dir[%s]", new Object[]{this.config.getDirectory()});
        }
        File outputFile = this.fileForTask(taskid, reportFile.getName());
        Files.copy((File)reportFile, (File)outputFile);
        log.info("Wrote task report to: %s", new Object[]{outputFile});
    }

    public Optional<ByteSource> streamTaskLog(String taskid, final long offset) {
        final File file = this.fileForTask(taskid, "log");
        if (file.exists()) {
            return Optional.of((Object)new ByteSource(){

                public InputStream openStream() throws IOException {
                    return LogUtils.streamFile(file, offset);
                }
            });
        }
        return Optional.absent();
    }

    public Optional<ByteSource> streamTaskReports(String taskid) {
        final File file = this.fileForTask(taskid, "report.json");
        if (file.exists()) {
            return Optional.of((Object)new ByteSource(){

                public InputStream openStream() throws IOException {
                    return LogUtils.streamFile(file, 0L);
                }
            });
        }
        return Optional.absent();
    }

    private File fileForTask(String taskid, String filename) {
        return new File(this.config.getDirectory(), StringUtils.format((String)"%s.%s", (Object[])new Object[]{taskid, filename}));
    }

    public void killAll() throws IOException {
        log.info("Deleting all task logs from local dir [%s].", new Object[]{this.config.getDirectory().getAbsolutePath()});
        org.apache.druid.java.util.common.FileUtils.deleteDirectory((File)this.config.getDirectory());
    }

    public void killOlderThan(long timestamp) throws IOException {
        File taskLogDir = this.config.getDirectory();
        if (taskLogDir.exists()) {
            File[] files;
            if (!taskLogDir.isDirectory()) {
                throw new IOE("taskLogDir [%s] must be a directory.", new Object[]{taskLogDir});
            }
            for (File file : files = taskLogDir.listFiles(f -> f.lastModified() < timestamp)) {
                log.info("Deleting local task log [%s].", new Object[]{file.getAbsolutePath()});
                FileUtils.forceDelete((File)file);
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new IOException(new InterruptedException("Thread interrupted. Couldn't delete all tasklogs."));
            }
        }
    }
}

