/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel.iterator;

import java.util.List;
import java.util.function.Consumer;
import org.apache.druid.data.input.HandlingInputRowIterator;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.DefaultIndexTaskInputRowIteratorBuilder;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.IndexTaskInputRowIteratorBuilder;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;

public class RangePartitionIndexTaskInputRowIteratorBuilder
implements IndexTaskInputRowIteratorBuilder {
    private final DefaultIndexTaskInputRowIteratorBuilder delegate = new DefaultIndexTaskInputRowIteratorBuilder();

    public RangePartitionIndexTaskInputRowIteratorBuilder(String partitionDimension, boolean skipNull) {
        if (skipNull) {
            this.delegate.appendInputRowHandler(RangePartitionIndexTaskInputRowIteratorBuilder.createOnlySingleDimensionValueRowsHandler(partitionDimension));
        } else {
            this.delegate.appendInputRowHandler(RangePartitionIndexTaskInputRowIteratorBuilder.createOnlySingleOrNullDimensionValueRowsHandler(partitionDimension));
        }
    }

    @Override
    public IndexTaskInputRowIteratorBuilder delegate(CloseableIterator<InputRow> inputRowIterator) {
        return this.delegate.delegate((CloseableIterator)inputRowIterator);
    }

    @Override
    public IndexTaskInputRowIteratorBuilder granularitySpec(GranularitySpec granularitySpec) {
        return this.delegate.granularitySpec(granularitySpec);
    }

    @Override
    public IndexTaskInputRowIteratorBuilder nullRowRunnable(Runnable nullRowRunnable) {
        return this.delegate.nullRowRunnable(nullRowRunnable);
    }

    @Override
    public IndexTaskInputRowIteratorBuilder absentBucketIntervalConsumer(Consumer<InputRow> absentBucketIntervalConsumer) {
        return this.delegate.absentBucketIntervalConsumer((Consumer)absentBucketIntervalConsumer);
    }

    @Override
    public HandlingInputRowIterator build() {
        return this.delegate.build();
    }

    private static HandlingInputRowIterator.InputRowHandler createOnlySingleDimensionValueRowsHandler(String partitionDimension) {
        return inputRow -> {
            int dimensionValueCount = RangePartitionIndexTaskInputRowIteratorBuilder.getSingleOrNullDimensionValueCount(inputRow, partitionDimension);
            return dimensionValueCount != 1;
        };
    }

    private static HandlingInputRowIterator.InputRowHandler createOnlySingleOrNullDimensionValueRowsHandler(String partitionDimension) {
        return inputRow -> {
            int dimensionValueCount = RangePartitionIndexTaskInputRowIteratorBuilder.getSingleOrNullDimensionValueCount(inputRow, partitionDimension);
            return dimensionValueCount > 1;
        };
    }

    private static int getSingleOrNullDimensionValueCount(InputRow inputRow, String partitionDimension) {
        List dimensionValues = inputRow.getDimension(partitionDimension);
        int dimensionValueCount = dimensionValues.size();
        if (dimensionValueCount > 1) {
            throw new IAE("Cannot partition on multi-value dimension [%s] for input row [%s]", new Object[]{partitionDimension, inputRow});
        }
        return dimensionValueCount;
    }
}

