/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel.iterator;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.druid.data.input.HandlingInputRowIterator;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.IndexTaskInputRowIteratorBuilder;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.joda.time.ReadableInstant;

public class DefaultIndexTaskInputRowIteratorBuilder
implements IndexTaskInputRowIteratorBuilder {
    private CloseableIterator<InputRow> delegate = null;
    private GranularitySpec granularitySpec = null;
    private HandlingInputRowIterator.InputRowHandler nullRowHandler = null;
    private HandlingInputRowIterator.InputRowHandler absentBucketIntervalHandler = null;
    private final List<HandlingInputRowIterator.InputRowHandler> appendedInputRowHandlers = new ArrayList<HandlingInputRowIterator.InputRowHandler>();

    @Override
    public DefaultIndexTaskInputRowIteratorBuilder delegate(CloseableIterator<InputRow> inputRowIterator) {
        this.delegate = inputRowIterator;
        return this;
    }

    @Override
    public DefaultIndexTaskInputRowIteratorBuilder granularitySpec(GranularitySpec granularitySpec) {
        this.granularitySpec = granularitySpec;
        return this;
    }

    @Override
    public DefaultIndexTaskInputRowIteratorBuilder nullRowRunnable(Runnable nullRowRunnable) {
        this.nullRowHandler = inputRow -> {
            if (inputRow == null) {
                nullRowRunnable.run();
                return true;
            }
            return false;
        };
        return this;
    }

    @Override
    public DefaultIndexTaskInputRowIteratorBuilder absentBucketIntervalConsumer(Consumer<InputRow> absentBucketIntervalConsumer) {
        this.absentBucketIntervalHandler = inputRow -> {
            Optional intervalOpt = this.granularitySpec.bucketInterval(inputRow.getTimestamp());
            if (!intervalOpt.isPresent()) {
                absentBucketIntervalConsumer.accept(inputRow);
                return true;
            }
            return false;
        };
        return this;
    }

    @Override
    public HandlingInputRowIterator build() {
        Preconditions.checkNotNull(this.delegate, (Object)"delegate required");
        Preconditions.checkNotNull((Object)this.granularitySpec, (Object)"granularitySpec required");
        Preconditions.checkNotNull((Object)this.nullRowHandler, (Object)"nullRowRunnable required");
        Preconditions.checkNotNull((Object)this.absentBucketIntervalHandler, (Object)"absentBucketIntervalConsumer required");
        ImmutableList.Builder handlersBuilder = ImmutableList.builder().add((Object)this.nullRowHandler).add((Object)this.createInvalidTimestampHandler()).add((Object)this.absentBucketIntervalHandler).addAll(this.appendedInputRowHandlers);
        return new HandlingInputRowIterator(this.delegate, (List)handlersBuilder.build());
    }

    DefaultIndexTaskInputRowIteratorBuilder appendInputRowHandler(HandlingInputRowIterator.InputRowHandler inputRowHandler) {
        this.appendedInputRowHandlers.add(inputRowHandler);
        return this;
    }

    private HandlingInputRowIterator.InputRowHandler createInvalidTimestampHandler() {
        return inputRow -> {
            if (!Intervals.ETERNITY.contains((ReadableInstant)inputRow.getTimestamp())) {
                String errorMsg = StringUtils.format((String)"Encountered row with timestamp that cannot be represented as a long: [%s]", (Object[])new Object[]{inputRow});
                throw new ParseException(errorMsg, new Object[0]);
            }
            return false;
        };
    }
}

