/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel.distribution;

import com.google.common.collect.ForwardingList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class PartitionBoundaries
extends ForwardingList<String>
implements List<String> {
    private final List<String> delegate;

    private PartitionBoundaries() {
        this.delegate = new ArrayList<String>();
    }

    public PartitionBoundaries(String ... partitions) {
        if (partitions.length == 0) {
            this.delegate = Collections.emptyList();
            return;
        }
        List partitionBoundaries = Arrays.stream(partitions).distinct().collect(Collectors.toCollection(ArrayList::new));
        partitionBoundaries.set(0, null);
        if (partitionBoundaries.size() == 1) {
            partitionBoundaries.add(null);
        } else {
            partitionBoundaries.set(partitionBoundaries.size() - 1, null);
        }
        this.delegate = Collections.unmodifiableList(partitionBoundaries);
    }

    protected List<String> delegate() {
        return this.delegate;
    }
}

