/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.indexing.common.task.batch.parallel.LegacySinglePhaseSubTask;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.SinglePhaseSubTask;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskSpec;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.appenderator.DummyForInjectionAppenderatorsManager;

class SinglePhaseSubTaskSpec
extends SubTaskSpec<SinglePhaseSubTask> {
    private final ParallelIndexIngestionSpec ingestionSpec;

    @JsonCreator
    SinglePhaseSubTaskSpec(String id, String groupId, String supervisorTaskId, ParallelIndexIngestionSpec indexIngestionSpec, Map<String, Object> context, InputSplit inputSplit) {
        super(id, groupId, supervisorTaskId, context, inputSplit);
        this.ingestionSpec = indexIngestionSpec;
    }

    @JsonProperty
    public ParallelIndexIngestionSpec getIngestionSpec() {
        return this.ingestionSpec;
    }

    @Override
    public SinglePhaseSubTask newSubTask(int numAttempts) {
        return new SinglePhaseSubTask(null, this.getGroupId(), null, this.getSupervisorTaskId(), numAttempts, this.getIngestionSpec(), this.getContext(), null, null, (AppenderatorsManager)new DummyForInjectionAppenderatorsManager());
    }

    @Override
    public SinglePhaseSubTask newSubTaskWithBackwardCompatibleType(int numAttempts) {
        return new LegacySinglePhaseSubTask(null, this.getGroupId(), null, this.getSupervisorTaskId(), numAttempts, this.getIngestionSpec(), this.getContext(), null, null, (AppenderatorsManager)new DummyForInjectionAppenderatorsManager());
    }
}

