/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.data.input.FirehoseFactoryToInputSourceAdaptor;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexPhaseRunner;
import org.apache.druid.indexing.common.task.batch.parallel.PushedSegmentsReport;
import org.apache.druid.indexing.common.task.batch.parallel.SinglePhaseSubTask;
import org.apache.druid.indexing.common.task.batch.parallel.SinglePhaseSubTaskSpec;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskSpec;

class SinglePhaseParallelIndexTaskRunner
extends ParallelIndexPhaseRunner<SinglePhaseSubTask, PushedSegmentsReport> {
    private static final String PHASE_NAME = "segment generation";
    private final ParallelIndexIngestionSpec ingestionSchema;
    private final SplittableInputSource<?> baseInputSource;

    SinglePhaseParallelIndexTaskRunner(TaskToolbox toolbox, String taskId, String groupId, ParallelIndexIngestionSpec ingestionSchema, Map<String, Object> context, IndexingServiceClient indexingServiceClient) {
        super(toolbox, taskId, groupId, ingestionSchema.getTuningConfig(), context, indexingServiceClient);
        this.ingestionSchema = ingestionSchema;
        this.baseInputSource = (SplittableInputSource)ingestionSchema.getIOConfig().getNonNullInputSource(ingestionSchema.getDataSchema().getParser());
    }

    @Override
    public String getName() {
        return PHASE_NAME;
    }

    @VisibleForTesting
    ParallelIndexIngestionSpec getIngestionSchema() {
        return this.ingestionSchema;
    }

    @Override
    @VisibleForTesting
    Iterator<SubTaskSpec<SinglePhaseSubTask>> subTaskSpecIterator() throws IOException {
        return this.baseInputSource.createSplits(this.ingestionSchema.getIOConfig().getInputFormat(), this.getTuningConfig().getSplitHintSpec()).map(this::newTaskSpec).iterator();
    }

    @Override
    int estimateTotalNumSubTasks() throws IOException {
        return this.baseInputSource.estimateNumSplits(this.ingestionSchema.getIOConfig().getInputFormat(), this.getTuningConfig().getSplitHintSpec());
    }

    @VisibleForTesting
    SubTaskSpec<SinglePhaseSubTask> newTaskSpec(InputSplit split) {
        SplittableInputSource inputSource;
        FiniteFirehoseFactory firehoseFactory;
        if (this.baseInputSource instanceof FirehoseFactoryToInputSourceAdaptor) {
            firehoseFactory = ((FirehoseFactoryToInputSourceAdaptor)this.baseInputSource).getFirehoseFactory().withSplit(split);
            inputSource = null;
        } else {
            firehoseFactory = null;
            inputSource = this.baseInputSource.withSplit(split);
        }
        return new SinglePhaseSubTaskSpec(this.getTaskId() + "_" + this.getAndIncrementNextSpecId(), this.getGroupId(), this.getTaskId(), new ParallelIndexIngestionSpec(this.ingestionSchema.getDataSchema(), new ParallelIndexIOConfig((FirehoseFactory)firehoseFactory, (InputSource)inputSource, this.ingestionSchema.getIOConfig().getInputFormat(), this.ingestionSchema.getIOConfig().isAppendToExisting()), this.ingestionSchema.getTuningConfig()), this.getContext(), split);
    }
}

