/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.joda.time.Interval;

abstract class PartitionStat<T> {
    private final String taskExecutorHost;
    private final int taskExecutorPort;
    private final boolean useHttps;
    private final Interval interval;
    @Nullable
    private final Integer numRows;
    @Nullable
    private final Long sizeBytes;

    PartitionStat(String taskExecutorHost, int taskExecutorPort, boolean useHttps, Interval interval, @Nullable Integer numRows, @Nullable Long sizeBytes) {
        this.taskExecutorHost = taskExecutorHost;
        this.taskExecutorPort = taskExecutorPort;
        this.useHttps = useHttps;
        this.interval = interval;
        this.numRows = numRows == null ? 0 : numRows;
        this.sizeBytes = sizeBytes == null ? 0L : sizeBytes;
    }

    @JsonProperty
    public final String getTaskExecutorHost() {
        return this.taskExecutorHost;
    }

    @JsonProperty
    public final int getTaskExecutorPort() {
        return this.taskExecutorPort;
    }

    @JsonProperty
    public final boolean isUseHttps() {
        return this.useHttps;
    }

    @JsonProperty
    public final Interval getInterval() {
        return this.interval;
    }

    @Nullable
    @JsonProperty
    public final Integer getNumRows() {
        return this.numRows;
    }

    @Nullable
    @JsonProperty
    public final Long getSizeBytes() {
        return this.sizeBytes;
    }

    abstract int getPartitionId();

    abstract T getSecondaryPartition();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionStat that = (PartitionStat)o;
        return this.taskExecutorPort == that.taskExecutorPort && this.useHttps == that.useHttps && Objects.equals(this.taskExecutorHost, that.taskExecutorHost) && Objects.equals(this.interval, that.interval) && Objects.equals(this.numRows, that.numRows) && Objects.equals(this.sizeBytes, that.sizeBytes);
    }

    public int hashCode() {
        return Objects.hash(this.taskExecutorHost, this.taskExecutorPort, this.useHttps, this.interval, this.numRows, this.sizeBytes);
    }
}

