/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.Objects;
import org.apache.druid.java.util.common.StringUtils;
import org.joda.time.Interval;

abstract class PartitionLocation<T> {
    private final String host;
    private final int port;
    private final boolean useHttps;
    private final String subTaskId;
    private final Interval interval;
    private final T secondaryPartition;

    PartitionLocation(String host, int port, boolean useHttps, String subTaskId, Interval interval, T secondaryPartition) {
        this.host = host;
        this.port = port;
        this.useHttps = useHttps;
        this.subTaskId = subTaskId;
        this.interval = interval;
        this.secondaryPartition = secondaryPartition;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public boolean isUseHttps() {
        return this.useHttps;
    }

    @JsonProperty
    public String getSubTaskId() {
        return this.subTaskId;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    abstract int getPartitionId();

    final URI toIntermediaryDataServerURI(String supervisorTaskId) {
        return URI.create(StringUtils.format((String)"%s://%s:%d/druid/worker/v1/shuffle/task/%s/%s/partition?startTime=%s&endTime=%s&partitionId=%d", (Object[])new Object[]{this.useHttps ? "https" : "http", this.host, this.port, StringUtils.urlEncode((String)supervisorTaskId), StringUtils.urlEncode((String)this.subTaskId), this.interval.getStart(), this.interval.getEnd(), this.getPartitionId()}));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionLocation that = (PartitionLocation)o;
        return this.port == that.port && this.useHttps == that.useHttps && Objects.equals(this.host, that.host) && Objects.equals(this.subTaskId, that.subTaskId) && Objects.equals(this.interval, that.interval) && Objects.equals(this.secondaryPartition, that.secondaryPartition);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.useHttps, this.subTaskId, this.interval, this.secondaryPartition);
    }

    public String toString() {
        return "PartitionLocation{host='" + this.host + '\'' + ", port=" + this.port + ", useHttps=" + this.useHttps + ", subTaskId='" + this.subTaskId + '\'' + ", interval=" + this.interval + ", secondaryPartition=" + this.secondaryPartition + '}';
    }
}

