/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.IndexTaskClientFactory;
import org.apache.druid.indexing.common.task.IndexTaskSegmentAllocator;
import org.apache.druid.indexing.common.task.RangePartitionCachingLocalSegmentAllocator;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.GeneratedPartitionsMetadataReport;
import org.apache.druid.indexing.common.task.batch.parallel.GenericPartitionStat;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.PartialSegmentGenerateTask;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.PartitionBoundaries;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.RangePartitionIndexTaskInputRowIteratorBuilder;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class PartialRangeSegmentGenerateTask
extends PartialSegmentGenerateTask<GeneratedPartitionsMetadataReport> {
    public static final String TYPE = "partial_range_index_generate";
    private static final String PROP_SPEC = "spec";
    private static final boolean SKIP_NULL = true;
    private final String supervisorTaskId;
    private final int numAttempts;
    private final ParallelIndexIngestionSpec ingestionSchema;
    private final Map<Interval, PartitionBoundaries> intervalToPartitions;

    @JsonCreator
    public PartialRangeSegmentGenerateTask(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="groupId") String groupId, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="supervisorTaskId") String supervisorTaskId, @JsonProperty(value="numAttempts") int numAttempts, @JsonProperty(value="spec") ParallelIndexIngestionSpec ingestionSchema, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="intervalToPartitions") Map<Interval, PartitionBoundaries> intervalToPartitions, @JacksonInject IndexingServiceClient indexingServiceClient, @JacksonInject IndexTaskClientFactory<ParallelIndexSupervisorTaskClient> taskClientFactory, @JacksonInject AppenderatorsManager appenderatorsManager) {
        super(PartialRangeSegmentGenerateTask.getOrMakeId(id, TYPE, ingestionSchema.getDataSchema().getDataSource()), groupId, taskResource, supervisorTaskId, ingestionSchema, context, indexingServiceClient, taskClientFactory, appenderatorsManager, new RangePartitionIndexTaskInputRowIteratorBuilder(PartialRangeSegmentGenerateTask.getPartitionDimension(ingestionSchema), false));
        this.numAttempts = numAttempts;
        this.ingestionSchema = ingestionSchema;
        this.supervisorTaskId = supervisorTaskId;
        this.intervalToPartitions = intervalToPartitions;
    }

    private static String getPartitionDimension(ParallelIndexIngestionSpec ingestionSpec) {
        PartitionsSpec partitionsSpec = ingestionSpec.getTuningConfig().getPartitionsSpec();
        Preconditions.checkArgument((boolean)(partitionsSpec instanceof SingleDimensionPartitionsSpec), (String)"%s partitionsSpec required", (Object[])new Object[]{"single_dim"});
        SingleDimensionPartitionsSpec singleDimPartitionsSpec = (SingleDimensionPartitionsSpec)partitionsSpec;
        String partitionDimension = singleDimPartitionsSpec.getPartitionDimension();
        Preconditions.checkNotNull((Object)partitionDimension, (Object)"partitionDimension required");
        return partitionDimension;
    }

    @JsonProperty
    public int getNumAttempts() {
        return this.numAttempts;
    }

    @JsonProperty(value="spec")
    public ParallelIndexIngestionSpec getIngestionSchema() {
        return this.ingestionSchema;
    }

    @JsonProperty
    public String getSupervisorTaskId() {
        return this.supervisorTaskId;
    }

    @JsonProperty
    public Map<Interval, PartitionBoundaries> getIntervalToPartitions() {
        return this.intervalToPartitions;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) {
        return true;
    }

    @Override
    IndexTaskSegmentAllocator createSegmentAllocator(TaskToolbox toolbox) throws IOException {
        return new RangePartitionCachingLocalSegmentAllocator(toolbox, this.getId(), this.supervisorTaskId, this.getDataSource(), PartialRangeSegmentGenerateTask.getPartitionDimension(this.ingestionSchema), this.intervalToPartitions);
    }

    @Override
    GeneratedPartitionsMetadataReport createGeneratedPartitionsReport(TaskToolbox toolbox, List<DataSegment> segments) {
        List<GenericPartitionStat> partitionStats = segments.stream().map(segment -> this.createPartitionStat(toolbox, (DataSegment)segment)).collect(Collectors.toList());
        return new GeneratedPartitionsMetadataReport(this.getId(), partitionStats);
    }

    private GenericPartitionStat createPartitionStat(TaskToolbox toolbox, DataSegment segment) {
        return new GenericPartitionStat(toolbox.getTaskExecutorNode().getHost(), toolbox.getTaskExecutorNode().getPortToUse(), toolbox.getTaskExecutorNode().isEnableTlsPort(), segment.getInterval(), segment.getShardSpec(), null, null);
    }
}

